/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.config;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final AtomicReference<ProxyConfig> proxyConfigReference = new AtomicReference();
    public static final String CONFIG_PATH_PROPERTY = "com.rocketmq.proxy.configPath";

    public void init() throws Exception {
        String proxyConfigData = Configuration.loadJsonConfig();
        ProxyConfig proxyConfig = (ProxyConfig)JSON.parseObject((String)proxyConfigData, ProxyConfig.class);
        proxyConfig.initData();
        this.setProxyConfig(proxyConfig);
    }

    public static String loadJsonConfig() throws Exception {
        String configFileName = "rmq-proxy.json";
        String filePath = System.getProperty(CONFIG_PATH_PROPERTY);
        if (StringUtils.isBlank((CharSequence)filePath)) {
            String testResource = "rmq-proxy-home/conf/" + configFileName;
            try (InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream(testResource);){
                if (null != inputStream) {
                    String string = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
                    return string;
                }
            }
            filePath = new File(ConfigurationManager.getProxyHome() + File.separator + "conf", configFileName).toString();
        }
        File file = new File(filePath);
        log.info("The current configuration file path is {}", (Object)filePath);
        if (!file.exists()) {
            log.warn("the config file {} not exist", (Object)filePath);
            throw new RuntimeException(String.format("the config file %s not exist", filePath));
        }
        long fileLength = file.length();
        if (fileLength <= 0L) {
            log.warn("the config file {} length is zero", (Object)filePath);
            throw new RuntimeException(String.format("the config file %s length is zero", filePath));
        }
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfigReference.get();
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfigReference.set(proxyConfig);
    }
}

