/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;

public class InFlightRequestFuture {
    private final long startOffset;
    private final List<Pair<Integer, CompletableFuture<Long>>> futureList;

    public InFlightRequestFuture(long startOffset, @Nonnull List<Pair<Integer, CompletableFuture<Long>>> futureList) {
        this.startOffset = startOffset;
        this.futureList = futureList;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public CompletableFuture<Long> getFirstFuture() {
        return this.futureList.isEmpty() ? CompletableFuture.completedFuture(-1L) : (CompletableFuture)this.futureList.get(0).getRight();
    }

    public CompletableFuture<Long> getFuture(long queueOffset) {
        if (queueOffset < this.startOffset) {
            return CompletableFuture.completedFuture(-1L);
        }
        long nextRequestOffset = this.startOffset;
        for (Pair<Integer, CompletableFuture<Long>> pair : this.futureList) {
            if (queueOffset >= (nextRequestOffset += (long)((Integer)pair.getLeft()).intValue())) continue;
            return (CompletableFuture)pair.getRight();
        }
        return CompletableFuture.completedFuture(-1L);
    }

    public CompletableFuture<Long> getLastFuture() {
        return this.futureList.isEmpty() ? CompletableFuture.completedFuture(-1L) : (CompletableFuture)this.futureList.get(this.futureList.size() - 1).getRight();
    }

    public boolean isFirstDone() {
        if (!this.futureList.isEmpty()) {
            return ((CompletableFuture)this.futureList.get(0).getRight()).isDone();
        }
        return true;
    }

    public boolean isAllDone() {
        for (Pair<Integer, CompletableFuture<Long>> pair : this.futureList) {
            if (((CompletableFuture)pair.getRight()).isDone()) continue;
            return false;
        }
        return true;
    }

    public List<CompletableFuture<Long>> getAllFuture() {
        return this.futureList.stream().map(Pair::getValue).collect(Collectors.toList());
    }
}

