/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.metadata.FileSegmentMetadata;
import org.apache.rocketmq.tieredstore.metadata.QueueMetadata;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataSerializeWrapper;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.metadata.TopicMetadata;

public class TieredMetadataManager
extends ConfigManager
implements TieredMetadataStore {
    private static final int DEFAULT_CAPACITY = 1024;
    private static final String DEFAULT_CONFIG_NAME = "config";
    private static final String DEFAULT_FILE_NAME = "tieredStoreMetadata.json";
    private final AtomicLong topicSequenceNumber;
    private final TieredMessageStoreConfig storeConfig;
    private final ConcurrentMap<String, TopicMetadata> topicMetadataTable;
    private final ConcurrentMap<String, ConcurrentMap<Integer, QueueMetadata>> queueMetadataTable;
    private final ConcurrentMap<String, ConcurrentMap<Long, FileSegmentMetadata>> commitLogFileSegmentTable;
    private final ConcurrentMap<String, ConcurrentMap<Long, FileSegmentMetadata>> consumeQueueFileSegmentTable;
    private final ConcurrentMap<String, ConcurrentMap<Long, FileSegmentMetadata>> indexFileSegmentTable;

    public TieredMetadataManager(TieredMessageStoreConfig storeConfig) {
        this.storeConfig = storeConfig;
        this.topicSequenceNumber = new AtomicLong(-1L);
        this.topicMetadataTable = new ConcurrentHashMap<String, TopicMetadata>(1024);
        this.queueMetadataTable = new ConcurrentHashMap<String, ConcurrentMap<Integer, QueueMetadata>>(1024);
        this.commitLogFileSegmentTable = new ConcurrentHashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>(1024);
        this.consumeQueueFileSegmentTable = new ConcurrentHashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>(1024);
        this.indexFileSegmentTable = new ConcurrentHashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>(1024);
        this.load();
    }

    public String encode() {
        return this.encode(false);
    }

    public String encode(boolean prettyFormat) {
        TieredMetadataSerializeWrapper dataWrapper = new TieredMetadataSerializeWrapper();
        dataWrapper.setTopicSerialNumber(this.topicSequenceNumber);
        dataWrapper.setTopicMetadataTable(this.topicMetadataTable);
        dataWrapper.setQueueMetadataTable(new ConcurrentHashMap<String, ConcurrentMap<Integer, QueueMetadata>>(this.queueMetadataTable));
        dataWrapper.setCommitLogFileSegmentTable(new ConcurrentHashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>(this.commitLogFileSegmentTable));
        dataWrapper.setConsumeQueueFileSegmentTable(new ConcurrentHashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>(this.consumeQueueFileSegmentTable));
        dataWrapper.setIndexFileSegmentTable(new ConcurrentHashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>(this.indexFileSegmentTable));
        if (prettyFormat) {
            return JSON.toJSONString((Object)((Object)dataWrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)((Object)dataWrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public String configFilePath() {
        return Paths.get(this.storeConfig.getStorePathRootDir(), DEFAULT_CONFIG_NAME, DEFAULT_FILE_NAME).toString();
    }

    public void decode(String jsonString) {
        TieredMetadataSerializeWrapper dataWrapper;
        if (jsonString != null && (dataWrapper = (TieredMetadataSerializeWrapper)((Object)TieredMetadataSerializeWrapper.fromJson((String)jsonString, TieredMetadataSerializeWrapper.class))) != null) {
            this.topicSequenceNumber.set(dataWrapper.getTopicSerialNumber().get());
            this.topicMetadataTable.putAll(dataWrapper.getTopicMetadataTable());
            dataWrapper.getQueueMetadataTable().forEach((topic, entry) -> {
                ConcurrentMap cfr_ignored_0 = this.queueMetadataTable.put((String)topic, new ConcurrentHashMap(entry));
            });
            dataWrapper.getCommitLogFileSegmentTable().forEach((filePath, entry) -> {
                ConcurrentMap cfr_ignored_0 = this.commitLogFileSegmentTable.put((String)filePath, new ConcurrentHashMap(entry));
            });
            dataWrapper.getConsumeQueueFileSegmentTable().forEach((filePath, entry) -> {
                ConcurrentMap cfr_ignored_0 = this.consumeQueueFileSegmentTable.put((String)filePath, new ConcurrentHashMap(entry));
            });
            dataWrapper.getIndexFileSegmentTable().forEach((filePath, entry) -> {
                ConcurrentMap cfr_ignored_0 = this.indexFileSegmentTable.put((String)filePath, new ConcurrentHashMap(entry));
            });
        }
    }

    @Override
    public void setTopicSequenceNumber(long topicSequenceNumber) {
        this.topicSequenceNumber.set(topicSequenceNumber);
    }

    @Override
    public TopicMetadata getTopic(String topic) {
        return (TopicMetadata)this.topicMetadataTable.get(topic);
    }

    @Override
    public void iterateTopic(Consumer<TopicMetadata> callback) {
        this.topicMetadataTable.values().forEach(callback);
    }

    @Override
    public TopicMetadata addTopic(String topic, long reserveTime) {
        TopicMetadata old = this.getTopic(topic);
        if (old != null) {
            return old;
        }
        TopicMetadata metadata = new TopicMetadata(this.topicSequenceNumber.incrementAndGet(), topic, reserveTime);
        this.topicMetadataTable.put(topic, metadata);
        this.persist();
        return metadata;
    }

    @Override
    public void updateTopic(TopicMetadata topicMetadata) {
        TopicMetadata metadata = this.getTopic(topicMetadata.getTopic());
        if (metadata == null) {
            return;
        }
        metadata.setUpdateTimestamp(System.currentTimeMillis());
        this.topicMetadataTable.put(topicMetadata.getTopic(), topicMetadata);
        this.persist();
    }

    @Override
    public void deleteTopic(String topic) {
        this.topicMetadataTable.remove(topic);
        this.persist();
    }

    @Override
    public QueueMetadata getQueue(MessageQueue mq) {
        return (QueueMetadata)((ConcurrentMap)this.queueMetadataTable.getOrDefault(mq.getTopic(), new ConcurrentHashMap())).get(mq.getQueueId());
    }

    @Override
    public void iterateQueue(String topic, Consumer<QueueMetadata> callback) {
        ((ConcurrentMap)this.queueMetadataTable.get(topic)).values().forEach(callback);
    }

    @Override
    public QueueMetadata addQueue(MessageQueue mq, long baseOffset) {
        QueueMetadata old = this.getQueue(mq);
        if (old != null) {
            return old;
        }
        QueueMetadata metadata = new QueueMetadata(mq, baseOffset, baseOffset);
        this.queueMetadataTable.computeIfAbsent(mq.getTopic(), topic -> new ConcurrentHashMap()).put(mq.getQueueId(), metadata);
        this.persist();
        return metadata;
    }

    @Override
    public void updateQueue(QueueMetadata metadata) {
        MessageQueue queue = metadata.getQueue();
        if (this.queueMetadataTable.containsKey(queue.getTopic())) {
            ConcurrentMap metadataMap = (ConcurrentMap)this.queueMetadataTable.get(queue.getTopic());
            if (metadataMap.containsKey(queue.getQueueId())) {
                metadata.setUpdateTimestamp(System.currentTimeMillis());
                metadataMap.put(queue.getQueueId(), metadata);
            }
            this.persist();
        }
    }

    @Override
    public void deleteQueue(MessageQueue mq) {
        if (this.queueMetadataTable.containsKey(mq.getTopic())) {
            ((ConcurrentMap)this.queueMetadataTable.get(mq.getTopic())).remove(mq.getQueueId());
        }
        this.persist();
    }

    @VisibleForTesting
    public Map<String, ConcurrentMap<Long, FileSegmentMetadata>> getTableByFileType(FileSegmentType fileType) {
        switch (fileType) {
            case COMMIT_LOG: {
                return this.commitLogFileSegmentTable;
            }
            case CONSUME_QUEUE: {
                return this.consumeQueueFileSegmentTable;
            }
            case INDEX: {
                return this.indexFileSegmentTable;
            }
        }
        return new HashMap<String, ConcurrentMap<Long, FileSegmentMetadata>>();
    }

    @Override
    public FileSegmentMetadata getFileSegment(String basePath, FileSegmentType fileType, long baseOffset) {
        return Optional.ofNullable(this.getTableByFileType(fileType).get(basePath)).map(fileMap -> (FileSegmentMetadata)fileMap.get(baseOffset)).orElse(null);
    }

    @Override
    public void updateFileSegment(FileSegmentMetadata fileSegmentMetadata) {
        FileSegmentType fileType = FileSegmentType.valueOf(fileSegmentMetadata.getType());
        ConcurrentMap offsetTable = this.getTableByFileType(fileType).computeIfAbsent(fileSegmentMetadata.getPath(), s -> new ConcurrentHashMap());
        offsetTable.put(fileSegmentMetadata.getBaseOffset(), fileSegmentMetadata);
        this.persist();
    }

    @Override
    public void iterateFileSegment(Consumer<FileSegmentMetadata> callback) {
        this.commitLogFileSegmentTable.forEach((filePath, map) -> map.forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata)));
        this.consumeQueueFileSegmentTable.forEach((filePath, map) -> map.forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata)));
        this.indexFileSegmentTable.forEach((filePath, map) -> map.forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata)));
    }

    @Override
    public void iterateFileSegment(String basePath, FileSegmentType fileType, Consumer<FileSegmentMetadata> callback) {
        ((ConcurrentMap)this.getTableByFileType(fileType).getOrDefault(basePath, new ConcurrentHashMap())).forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata));
    }

    @Override
    public void deleteFileSegment(String filePath, FileSegmentType fileType) {
        Map<String, ConcurrentMap<Long, FileSegmentMetadata>> offsetTable = this.getTableByFileType(fileType);
        if (offsetTable != null) {
            offsetTable.remove(filePath);
        }
        this.persist();
    }

    @Override
    public void deleteFileSegment(String basePath, FileSegmentType fileType, long baseOffset) {
        ConcurrentMap<Long, FileSegmentMetadata> offsetTable = this.getTableByFileType(fileType).get(basePath);
        if (offsetTable != null) {
            offsetTable.remove(baseOffset);
        }
        this.persist();
    }

    @Override
    public void destroy() {
        this.topicSequenceNumber.set(0L);
        this.topicMetadataTable.clear();
        this.queueMetadataTable.clear();
        this.commitLogFileSegmentTable.clear();
        this.consumeQueueFileSegmentTable.clear();
        this.indexFileSegmentTable.clear();
        this.persist();
    }
}

