/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.utils.NameServerAddressUtils;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RequestType;

public class ClientConfig {
    public static final String SEND_MESSAGE_WITH_VIP_CHANNEL_PROPERTY = "com.rocketmq.sendMessageWithVIPChannel";
    public static final String SOCKS_PROXY_CONFIG = "com.rocketmq.socks.proxy.config";
    public static final String DECODE_READ_BODY = "com.rocketmq.read.body";
    public static final String DECODE_DECOMPRESS_BODY = "com.rocketmq.decompress.body";
    public static final String SEND_LATENCY_ENABLE = "com.rocketmq.sendLatencyEnable";
    public static final String START_DETECTOR_ENABLE = "com.rocketmq.startDetectorEnable";
    public static final String HEART_BEAT_V2 = "com.rocketmq.heartbeat.v2";
    private String namesrvAddr = NameServerAddressUtils.getNameServerAddresses();
    private String clientIP = NetworkUtil.getLocalAddress();
    private String instanceName = System.getProperty("rocketmq.client.name", "DEFAULT");
    private int clientCallbackExecutorThreads = Runtime.getRuntime().availableProcessors();
    @Deprecated
    protected String namespace;
    private boolean namespaceInitialized = false;
    protected String namespaceV2;
    protected AccessChannel accessChannel = AccessChannel.LOCAL;
    private int pollNameServerInterval = 30000;
    private int heartbeatBrokerInterval = 30000;
    private int persistConsumerOffsetInterval = 5000;
    private long pullTimeDelayMillsWhenException = 1000L;
    private boolean unitMode = false;
    private String unitName;
    private boolean decodeReadBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.read.body", "true"));
    private boolean decodeDecompressBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.decompress.body", "true"));
    private boolean vipChannelEnabled = Boolean.parseBoolean(System.getProperty("com.rocketmq.sendMessageWithVIPChannel", "false"));
    private boolean useHeartbeatV2 = Boolean.parseBoolean(System.getProperty("com.rocketmq.heartbeat.v2", "false"));
    private boolean useTLS = TlsSystemConfig.tlsEnable;
    private String socksProxyConfig = System.getProperty("com.rocketmq.socks.proxy.config", "{}");
    private int mqClientApiTimeout = 3000;
    private int detectTimeout = 200;
    private int detectInterval = 2000;
    private LanguageCode language = LanguageCode.JAVA;
    protected boolean enableStreamRequestType = false;
    private boolean sendLatencyEnable = Boolean.parseBoolean(System.getProperty("com.rocketmq.sendLatencyEnable", "false"));
    private boolean startDetectorEnable = Boolean.parseBoolean(System.getProperty("com.rocketmq.startDetectorEnable", "false"));
    private boolean enableHeartbeatChannelEventListener = true;

    public String buildMQClientId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClientIP());
        sb.append("@");
        sb.append(this.getInstanceName());
        if (!UtilAll.isBlank((String)this.unitName)) {
            sb.append("@");
            sb.append(this.unitName);
        }
        if (this.enableStreamRequestType) {
            sb.append("@");
            sb.append(RequestType.STREAM);
        }
        return sb.toString();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void changeInstanceNameToPID() {
        if (this.instanceName.equals("DEFAULT")) {
            this.instanceName = UtilAll.getPid() + "#" + System.nanoTime();
        }
    }

    @Deprecated
    public String withNamespace(String resource) {
        return NamespaceUtil.wrapNamespace((String)this.getNamespace(), (String)resource);
    }

    @Deprecated
    public Set<String> withNamespace(Set<String> resourceSet) {
        HashSet<String> resourceWithNamespace = new HashSet<String>();
        for (String resource : resourceSet) {
            resourceWithNamespace.add(this.withNamespace(resource));
        }
        return resourceWithNamespace;
    }

    @Deprecated
    public String withoutNamespace(String resource) {
        return NamespaceUtil.withoutNamespace((String)resource, (String)this.getNamespace());
    }

    @Deprecated
    public Set<String> withoutNamespace(Set<String> resourceSet) {
        HashSet<String> resourceWithoutNamespace = new HashSet<String>();
        for (String resource : resourceSet) {
            resourceWithoutNamespace.add(this.withoutNamespace(resource));
        }
        return resourceWithoutNamespace;
    }

    @Deprecated
    public MessageQueue queueWithNamespace(MessageQueue queue) {
        if (StringUtils.isEmpty((CharSequence)this.getNamespace())) {
            return queue;
        }
        return new MessageQueue(this.withNamespace(queue.getTopic()), queue.getBrokerName(), queue.getQueueId());
    }

    @Deprecated
    public Collection<MessageQueue> queuesWithNamespace(Collection<MessageQueue> queues) {
        if (StringUtils.isEmpty((CharSequence)this.getNamespace())) {
            return queues;
        }
        for (MessageQueue queue : queues) {
            queue.setTopic(this.withNamespace(queue.getTopic()));
        }
        return queues;
    }

    public void resetClientConfig(ClientConfig cc) {
        this.namesrvAddr = cc.namesrvAddr;
        this.clientIP = cc.clientIP;
        this.instanceName = cc.instanceName;
        this.clientCallbackExecutorThreads = cc.clientCallbackExecutorThreads;
        this.pollNameServerInterval = cc.pollNameServerInterval;
        this.heartbeatBrokerInterval = cc.heartbeatBrokerInterval;
        this.persistConsumerOffsetInterval = cc.persistConsumerOffsetInterval;
        this.pullTimeDelayMillsWhenException = cc.pullTimeDelayMillsWhenException;
        this.unitMode = cc.unitMode;
        this.unitName = cc.unitName;
        this.vipChannelEnabled = cc.vipChannelEnabled;
        this.useTLS = cc.useTLS;
        this.socksProxyConfig = cc.socksProxyConfig;
        this.namespace = cc.namespace;
        this.language = cc.language;
        this.mqClientApiTimeout = cc.mqClientApiTimeout;
        this.decodeReadBody = cc.decodeReadBody;
        this.decodeDecompressBody = cc.decodeDecompressBody;
        this.enableStreamRequestType = cc.enableStreamRequestType;
        this.useHeartbeatV2 = cc.useHeartbeatV2;
        this.startDetectorEnable = cc.startDetectorEnable;
        this.sendLatencyEnable = cc.sendLatencyEnable;
        this.enableHeartbeatChannelEventListener = cc.enableHeartbeatChannelEventListener;
        this.detectInterval = cc.detectInterval;
        this.detectTimeout = cc.detectTimeout;
        this.namespaceV2 = cc.namespaceV2;
    }

    public ClientConfig cloneClientConfig() {
        ClientConfig cc = new ClientConfig();
        cc.namesrvAddr = this.namesrvAddr;
        cc.clientIP = this.clientIP;
        cc.instanceName = this.instanceName;
        cc.clientCallbackExecutorThreads = this.clientCallbackExecutorThreads;
        cc.pollNameServerInterval = this.pollNameServerInterval;
        cc.heartbeatBrokerInterval = this.heartbeatBrokerInterval;
        cc.persistConsumerOffsetInterval = this.persistConsumerOffsetInterval;
        cc.pullTimeDelayMillsWhenException = this.pullTimeDelayMillsWhenException;
        cc.unitMode = this.unitMode;
        cc.unitName = this.unitName;
        cc.vipChannelEnabled = this.vipChannelEnabled;
        cc.useTLS = this.useTLS;
        cc.socksProxyConfig = this.socksProxyConfig;
        cc.namespace = this.namespace;
        cc.language = this.language;
        cc.mqClientApiTimeout = this.mqClientApiTimeout;
        cc.decodeReadBody = this.decodeReadBody;
        cc.decodeDecompressBody = this.decodeDecompressBody;
        cc.enableStreamRequestType = this.enableStreamRequestType;
        cc.useHeartbeatV2 = this.useHeartbeatV2;
        cc.startDetectorEnable = this.startDetectorEnable;
        cc.enableHeartbeatChannelEventListener = this.enableHeartbeatChannelEventListener;
        cc.sendLatencyEnable = this.sendLatencyEnable;
        cc.detectInterval = this.detectInterval;
        cc.detectTimeout = this.detectTimeout;
        cc.namespaceV2 = this.namespaceV2;
        return cc;
    }

    public String getNamesrvAddr() {
        if (StringUtils.isNotEmpty((CharSequence)this.namesrvAddr) && NameServerAddressUtils.NAMESRV_ENDPOINT_PATTERN.matcher(this.namesrvAddr.trim()).matches()) {
            return NameServerAddressUtils.getNameSrvAddrFromNamesrvEndpoint((String)this.namesrvAddr);
        }
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
        this.namespaceInitialized = false;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int clientCallbackExecutorThreads) {
        this.clientCallbackExecutorThreads = clientCallbackExecutorThreads;
    }

    public int getPollNameServerInterval() {
        return this.pollNameServerInterval;
    }

    public void setPollNameServerInterval(int pollNameServerInterval) {
        this.pollNameServerInterval = pollNameServerInterval;
    }

    public int getHeartbeatBrokerInterval() {
        return this.heartbeatBrokerInterval;
    }

    public void setHeartbeatBrokerInterval(int heartbeatBrokerInterval) {
        this.heartbeatBrokerInterval = heartbeatBrokerInterval;
    }

    public int getPersistConsumerOffsetInterval() {
        return this.persistConsumerOffsetInterval;
    }

    public void setPersistConsumerOffsetInterval(int persistConsumerOffsetInterval) {
        this.persistConsumerOffsetInterval = persistConsumerOffsetInterval;
    }

    public long getPullTimeDelayMillsWhenException() {
        return this.pullTimeDelayMillsWhenException;
    }

    public void setPullTimeDelayMillsWhenException(long pullTimeDelayMillsWhenException) {
        this.pullTimeDelayMillsWhenException = pullTimeDelayMillsWhenException;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public boolean isUnitMode() {
        return this.unitMode;
    }

    public void setUnitMode(boolean unitMode) {
        this.unitMode = unitMode;
    }

    public boolean isVipChannelEnabled() {
        return this.vipChannelEnabled;
    }

    public void setVipChannelEnabled(boolean vipChannelEnabled) {
        this.vipChannelEnabled = vipChannelEnabled;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public String getSocksProxyConfig() {
        return this.socksProxyConfig;
    }

    public void setSocksProxyConfig(String socksProxyConfig) {
        this.socksProxyConfig = socksProxyConfig;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public boolean isDecodeReadBody() {
        return this.decodeReadBody;
    }

    public void setDecodeReadBody(boolean decodeReadBody) {
        this.decodeReadBody = decodeReadBody;
    }

    public boolean isDecodeDecompressBody() {
        return this.decodeDecompressBody;
    }

    public void setDecodeDecompressBody(boolean decodeDecompressBody) {
        this.decodeDecompressBody = decodeDecompressBody;
    }

    @Deprecated
    public String getNamespace() {
        if (this.namespaceInitialized) {
            return this.namespace;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.namespace)) {
            return this.namespace;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.namesrvAddr) && NameServerAddressUtils.validateInstanceEndpoint((String)this.namesrvAddr)) {
            this.namespace = NameServerAddressUtils.parseInstanceIdFromEndpoint((String)this.namesrvAddr);
        }
        this.namespaceInitialized = true;
        return this.namespace;
    }

    @Deprecated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.namespaceInitialized = true;
    }

    public String getNamespaceV2() {
        return this.namespaceV2;
    }

    public void setNamespaceV2(String namespaceV2) {
        this.namespaceV2 = namespaceV2;
    }

    public AccessChannel getAccessChannel() {
        return this.accessChannel;
    }

    public void setAccessChannel(AccessChannel accessChannel) {
        this.accessChannel = accessChannel;
    }

    public int getMqClientApiTimeout() {
        return this.mqClientApiTimeout;
    }

    public void setMqClientApiTimeout(int mqClientApiTimeout) {
        this.mqClientApiTimeout = mqClientApiTimeout;
    }

    public boolean isEnableStreamRequestType() {
        return this.enableStreamRequestType;
    }

    public void setEnableStreamRequestType(boolean enableStreamRequestType) {
        this.enableStreamRequestType = enableStreamRequestType;
    }

    public boolean isSendLatencyEnable() {
        return this.sendLatencyEnable;
    }

    public void setSendLatencyEnable(boolean sendLatencyEnable) {
        this.sendLatencyEnable = sendLatencyEnable;
    }

    public boolean isStartDetectorEnable() {
        return this.startDetectorEnable;
    }

    public void setStartDetectorEnable(boolean startDetectorEnable) {
        this.startDetectorEnable = startDetectorEnable;
    }

    public boolean isEnableHeartbeatChannelEventListener() {
        return this.enableHeartbeatChannelEventListener;
    }

    public void setEnableHeartbeatChannelEventListener(boolean enableHeartbeatChannelEventListener) {
        this.enableHeartbeatChannelEventListener = enableHeartbeatChannelEventListener;
    }

    public int getDetectTimeout() {
        return this.detectTimeout;
    }

    public void setDetectTimeout(int detectTimeout) {
        this.detectTimeout = detectTimeout;
    }

    public int getDetectInterval() {
        return this.detectInterval;
    }

    public void setDetectInterval(int detectInterval) {
        this.detectInterval = detectInterval;
    }

    public boolean isUseHeartbeatV2() {
        return this.useHeartbeatV2;
    }

    public void setUseHeartbeatV2(boolean useHeartbeatV2) {
        this.useHeartbeatV2 = useHeartbeatV2;
    }

    public String toString() {
        return "ClientConfig{namesrvAddr='" + this.namesrvAddr + '\'' + ", clientIP='" + this.clientIP + '\'' + ", instanceName='" + this.instanceName + '\'' + ", clientCallbackExecutorThreads=" + this.clientCallbackExecutorThreads + ", namespace='" + this.namespace + '\'' + ", namespaceInitialized=" + this.namespaceInitialized + ", namespaceV2='" + this.namespaceV2 + '\'' + ", accessChannel=" + (Object)((Object)this.accessChannel) + ", pollNameServerInterval=" + this.pollNameServerInterval + ", heartbeatBrokerInterval=" + this.heartbeatBrokerInterval + ", persistConsumerOffsetInterval=" + this.persistConsumerOffsetInterval + ", pullTimeDelayMillsWhenException=" + this.pullTimeDelayMillsWhenException + ", unitMode=" + this.unitMode + ", unitName='" + this.unitName + '\'' + ", decodeReadBody=" + this.decodeReadBody + ", decodeDecompressBody=" + this.decodeDecompressBody + ", vipChannelEnabled=" + this.vipChannelEnabled + ", useHeartbeatV2=" + this.useHeartbeatV2 + ", useTLS=" + this.useTLS + ", socksProxyConfig='" + this.socksProxyConfig + '\'' + ", mqClientApiTimeout=" + this.mqClientApiTimeout + ", detectTimeout=" + this.detectTimeout + ", detectInterval=" + this.detectInterval + ", language=" + this.language + ", enableStreamRequestType=" + this.enableStreamRequestType + ", sendLatencyEnable=" + this.sendLatencyEnable + ", startDetectorEnable=" + this.startDetectorEnable + ", enableHeartbeatChannelEventListener=" + this.enableHeartbeatChannelEventListener + '}';
    }
}

