/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.controller.helper.BrokerValidPredicate;
import org.apache.rocketmq.controller.impl.event.ControllerResult;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerIdentityInfo;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerLiveInfo;
import org.apache.rocketmq.controller.impl.manager.ReplicasInfoManager;
import org.apache.rocketmq.controller.impl.task.BrokerCloseChannelRequest;
import org.apache.rocketmq.controller.impl.task.BrokerCloseChannelResponse;
import org.apache.rocketmq.controller.impl.task.CheckNotActiveBrokerRequest;
import org.apache.rocketmq.controller.impl.task.CheckNotActiveBrokerResponse;
import org.apache.rocketmq.controller.impl.task.GetBrokerLiveInfoRequest;
import org.apache.rocketmq.controller.impl.task.GetBrokerLiveInfoResponse;
import org.apache.rocketmq.controller.impl.task.RaftBrokerHeartBeatEventRequest;
import org.apache.rocketmq.controller.impl.task.RaftBrokerHeartBeatEventResponse;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class RaftReplicasInfoManager
extends ReplicasInfoManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final Map<BrokerIdentityInfo, BrokerLiveInfo> brokerLiveTable = new ConcurrentHashMap<BrokerIdentityInfo, BrokerLiveInfo>(256);

    public RaftReplicasInfoManager(ControllerConfig controllerConfig) {
        super(controllerConfig);
    }

    public ControllerResult<GetBrokerLiveInfoResponse> getBrokerLiveInfo(GetBrokerLiveInfoRequest request) {
        BrokerIdentityInfo brokerIdentityInfo = request.getBrokerIdentity();
        ControllerResult<GetBrokerLiveInfoResponse> result = new ControllerResult<GetBrokerLiveInfoResponse>(new GetBrokerLiveInfoResponse());
        HashMap<BrokerIdentityInfo, BrokerLiveInfo> resBrokerLiveTable = new HashMap<BrokerIdentityInfo, BrokerLiveInfo>();
        if (brokerIdentityInfo == null || brokerIdentityInfo.isEmpty()) {
            resBrokerLiveTable.putAll(this.brokerLiveTable);
        } else if (this.brokerLiveTable.containsKey(brokerIdentityInfo)) {
            resBrokerLiveTable.put(brokerIdentityInfo, this.brokerLiveTable.get(brokerIdentityInfo));
        } else {
            log.warn("GetBrokerLiveInfo failed, brokerIdentityInfo: {} not exist", (Object)brokerIdentityInfo);
            result.setCodeAndRemark(2016, "brokerIdentityInfo not exist");
        }
        try {
            result.setBody(JSON.toJSONBytes(resBrokerLiveTable, (SerializerFeature[])new SerializerFeature[0]));
        }
        catch (Throwable e) {
            log.error("json serialize resBrokerLiveTable {} error", resBrokerLiveTable, (Object)e);
            result.setCodeAndRemark(1, "serialize error");
        }
        return result;
    }

    public ControllerResult<RaftBrokerHeartBeatEventResponse> onBrokerHeartBeat(RaftBrokerHeartBeatEventRequest request) {
        BrokerIdentityInfo brokerIdentityInfo = request.getBrokerIdentityInfo();
        BrokerLiveInfo brokerLiveInfo = request.getBrokerLiveInfo();
        ControllerResult<RaftBrokerHeartBeatEventResponse> result = new ControllerResult<RaftBrokerHeartBeatEventResponse>(new RaftBrokerHeartBeatEventResponse());
        BrokerLiveInfo prev = this.brokerLiveTable.computeIfAbsent(brokerIdentityInfo, identityInfo -> {
            log.info("new broker registered, brokerIdentityInfo: {}", identityInfo);
            return brokerLiveInfo;
        });
        prev.setLastUpdateTimestamp(brokerLiveInfo.getLastUpdateTimestamp());
        prev.setHeartbeatTimeoutMillis(brokerLiveInfo.getHeartbeatTimeoutMillis());
        prev.setElectionPriority(brokerLiveInfo.getElectionPriority());
        if (brokerLiveInfo.getEpoch() > prev.getEpoch() || brokerLiveInfo.getEpoch() == prev.getEpoch() && brokerLiveInfo.getMaxOffset() > prev.getMaxOffset()) {
            prev.setEpoch(brokerLiveInfo.getEpoch());
            prev.setMaxOffset(brokerLiveInfo.getMaxOffset());
            prev.setConfirmOffset(brokerLiveInfo.getConfirmOffset());
        }
        return result;
    }

    public ControllerResult<BrokerCloseChannelResponse> onBrokerCloseChannel(BrokerCloseChannelRequest request) {
        BrokerIdentityInfo brokerIdentityInfo = request.getBrokerIdentityInfo();
        ControllerResult<BrokerCloseChannelResponse> result = new ControllerResult<BrokerCloseChannelResponse>(new BrokerCloseChannelResponse());
        if (brokerIdentityInfo == null || brokerIdentityInfo.isEmpty()) {
            log.warn("onBrokerCloseChannel failed, brokerIdentityInfo is null");
        } else {
            this.brokerLiveTable.remove(brokerIdentityInfo);
            log.info("onBrokerCloseChannel success, brokerIdentityInfo: {}", (Object)brokerIdentityInfo);
        }
        return result;
    }

    public ControllerResult<CheckNotActiveBrokerResponse> checkNotActiveBroker(CheckNotActiveBrokerRequest request) {
        ArrayList<BrokerIdentityInfo> notActiveBrokerIdentityInfoList = new ArrayList<BrokerIdentityInfo>();
        final long checkTime = request.getCheckTimeMillis();
        Iterator<Map.Entry<BrokerIdentityInfo, BrokerLiveInfo>> iterator = this.brokerLiveTable.entrySet().iterator();
        while (iterator.hasNext()) {
            long timeoutMillis;
            Map.Entry<BrokerIdentityInfo, BrokerLiveInfo> next = iterator.next();
            long last = next.getValue().getLastUpdateTimestamp();
            if (checkTime - last <= (timeoutMillis = next.getValue().getHeartbeatTimeoutMillis())) continue;
            notActiveBrokerIdentityInfoList.add(next.getKey());
            iterator.remove();
            log.warn("Broker expired, brokerInfo {}, expired {}ms", (Object)next.getKey(), (Object)timeoutMillis);
        }
        List<String> needReElectBrokerNames = this.scanNeedReelectBrokerSets(new BrokerValidPredicate(){

            @Override
            public boolean check(String clusterName, String brokerName, Long brokerId) {
                return !RaftReplicasInfoManager.this.isBrokerActive(clusterName, brokerName, brokerId, checkTime);
            }
        });
        Set alreadyReportedBrokerName = notActiveBrokerIdentityInfoList.stream().map(BrokerIdentityInfo::getBrokerName).collect(Collectors.toSet());
        notActiveBrokerIdentityInfoList.addAll(needReElectBrokerNames.stream().filter(brokerName -> !alreadyReportedBrokerName.contains(brokerName)).map(brokerName -> new BrokerIdentityInfo(null, (String)brokerName, null)).collect(Collectors.toList()));
        ControllerResult<CheckNotActiveBrokerResponse> result = new ControllerResult<CheckNotActiveBrokerResponse>(new CheckNotActiveBrokerResponse());
        try {
            result.setBody(JSON.toJSONBytes(notActiveBrokerIdentityInfoList, (SerializerFeature[])new SerializerFeature[0]));
        }
        catch (Throwable e) {
            log.error("json serialize notActiveBrokerIdentityInfoList {} error", notActiveBrokerIdentityInfoList, (Object)e);
            result.setCodeAndRemark(1, "serialize error");
        }
        return result;
    }

    public boolean isBrokerActive(String clusterName, String brokerName, Long brokerId, long invokeTime) {
        BrokerLiveInfo info = this.brokerLiveTable.get(new BrokerIdentityInfo(clusterName, brokerName, brokerId));
        if (info != null) {
            long timeoutMillis;
            long last = info.getLastUpdateTimestamp();
            return last + (timeoutMillis = info.getHeartbeatTimeoutMillis()) >= invokeTime;
        }
        return false;
    }

    public BrokerLiveInfo getBrokerLiveInfo(String clusterName, String brokerName, Long brokerId) {
        return this.brokerLiveTable.get(new BrokerIdentityInfo(clusterName, brokerName, brokerId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize() throws Throwable {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] superSerialize = super.serialize();
            this.putInt(outputStream, superSerialize.length);
            outputStream.write(superSerialize);
            this.putInt(outputStream, this.brokerLiveTable.size());
            for (Map.Entry<BrokerIdentityInfo, BrokerLiveInfo> entry : this.brokerLiveTable.entrySet()) {
                byte[] brokerIdentityInfo = RaftReplicasInfoManager.hessianSerialize(entry.getKey());
                byte[] brokerLiveInfo = RaftReplicasInfoManager.hessianSerialize(entry.getValue());
                this.putInt(outputStream, brokerIdentityInfo.length);
                outputStream.write(brokerIdentityInfo);
                this.putInt(outputStream, brokerLiveInfo.length);
                outputStream.write(brokerLiveInfo);
            }
            Object object = outputStream.toByteArray();
            return object;
        }
        catch (Throwable e) {
            log.error("serialize replicaInfoTable or syncStateSetInfoTable error", e);
            throw e;
        }
    }

    @Override
    public void deserializeFrom(byte[] data) throws Throwable {
        int index = 0;
        this.brokerLiveTable.clear();
        try {
            int superTableSize = this.getInt(data, index);
            byte[] superTableData = new byte[superTableSize];
            System.arraycopy(data, index += 4, superTableData, 0, superTableSize);
            super.deserializeFrom(superTableData);
            int brokerLiveTableSize = this.getInt(data, index += superTableSize);
            index += 4;
            for (int i = 0; i < brokerLiveTableSize; ++i) {
                int brokerIdentityInfoLength = this.getInt(data, index);
                byte[] brokerIdentityInfoArray = new byte[brokerIdentityInfoLength];
                System.arraycopy(data, index += 4, brokerIdentityInfoArray, 0, brokerIdentityInfoLength);
                BrokerIdentityInfo brokerIdentityInfo = (BrokerIdentityInfo)RaftReplicasInfoManager.hessianDeserialize(brokerIdentityInfoArray);
                int brokerLiveInfoLength = this.getInt(data, index += brokerIdentityInfoLength);
                byte[] brokerLiveInfoArray = new byte[brokerLiveInfoLength];
                System.arraycopy(data, index += 4, brokerLiveInfoArray, 0, brokerLiveInfoLength);
                BrokerLiveInfo brokerLiveInfo = (BrokerLiveInfo)RaftReplicasInfoManager.hessianDeserialize(brokerLiveInfoArray);
                index += brokerLiveInfoLength;
                this.brokerLiveTable.put(brokerIdentityInfo, brokerLiveInfo);
            }
        }
        catch (Throwable e) {
            log.error("deserialize replicaInfoTable or syncStateSetInfoTable error", e);
            throw e;
        }
    }

    public static class BrokerValidPredicateWithInvokeTime
    implements BrokerValidPredicate {
        private final long invokeTime;
        private final RaftReplicasInfoManager raftBrokerHeartBeatManager;

        public BrokerValidPredicateWithInvokeTime(long invokeTime, RaftReplicasInfoManager raftBrokerHeartBeatManager) {
            this.invokeTime = invokeTime;
            this.raftBrokerHeartBeatManager = raftBrokerHeartBeatManager;
        }

        @Override
        public boolean check(String clusterName, String brokerName, Long brokerId) {
            return this.raftBrokerHeartBeatManager.isBrokerActive(clusterName, brokerName, brokerId, this.invokeTime);
        }
    }
}

