/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.guava;

import com.google.common.collect.Ordering;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.ConcatSequence;
import io.druid.java.util.common.guava.MappedSequence;
import io.druid.java.util.common.guava.MergeSequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.guava.Yielder;
import io.druid.java.util.common.guava.YieldingAccumulator;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.function.Function;

public interface Sequence<T> {
    public <OutType> OutType accumulate(OutType var1, Accumulator<OutType, T> var2);

    public <OutType> Yielder<OutType> toYielder(OutType var1, YieldingAccumulator<OutType, T> var2);

    default public <U> Sequence<U> map(Function<? super T, ? extends U> mapper) {
        return new MappedSequence<T, U>(this, mapper);
    }

    default public <R> Sequence<R> flatMap(Function<? super T, ? extends Sequence<? extends R>> mapper) {
        return new ConcatSequence(this.map(mapper));
    }

    default public <R> Sequence<R> flatMerge(Function<? super T, ? extends Sequence<? extends R>> mapper, Ordering<? super R> ordering) {
        return new MergeSequence<R>(ordering, this.map(mapper));
    }

    default public Sequence<T> withEffect(Runnable effect, Executor effectExecutor) {
        return Sequences.withEffect(this, effect, effectExecutor);
    }

    default public Sequence<T> withBaggage(Closeable baggage) {
        return Sequences.withBaggage(this, baggage);
    }
}

