/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hyperic.jni.ArchLoader;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;

public class ArchNameTask
extends Task {
    public void execute() throws BuildException {
        File dir;
        String compiler;
        String archName;
        String osArch = System.getProperty("os.arch");
        String osVers = System.getProperty("os.version");
        if (this.getProject().getProperty("jni.dmalloc") != null) {
            ArchName.useDmalloc = true;
        }
        try {
            archName = ArchName.getName();
        }
        catch (ArchNotSupportedException e) {
            System.out.println(e.getMessage());
            return;
        }
        System.out.println(archName);
        this.getProject().setProperty("jni.libarch", archName);
        this.getProject().setProperty("jni.libpre", ArchLoader.getLibraryPrefix());
        this.getProject().setProperty("jni.libext", ArchLoader.getLibraryExtension());
        if (ArchLoader.IS_WIN32) {
            compiler = "msvc";
        } else if (ArchLoader.IS_HPUX) {
            compiler = "hp";
        } else if (ArchLoader.IS_AIX) {
            compiler = "xlc_r";
        } else {
            compiler = "gcc";
            this.getProject().setProperty("jni.compiler.isgcc", "true");
        }
        this.getProject().setProperty("jni.compiler", compiler);
        if (ArchName.is64()) {
            this.getProject().setProperty("jni.arch64", "true");
            if (ArchLoader.IS_LINUX && !osArch.equals("ia64") && !osArch.equals("loongarch64")) {
                this.getProject().setProperty("jni.gccm", "-m64");
            }
        } else if (ArchLoader.IS_LINUX && osArch.equals("s390")) {
            this.getProject().setProperty("jni.gccm", "-m31");
        }
        if (ArchLoader.IS_DARWIN) {
            Object[] sdks;
            String sdkRoot = "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs";
            if (!new File(sdkRoot).exists()) {
                sdkRoot = "/Developer/SDKs";
            }
            if ((sdks = new File(sdkRoot).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String name = file.getName();
                    return name.startsWith("MacOSX10.") && name.endsWith(".sdk");
                }
            })) != null) {
                Arrays.sort(sdks);
                String prop = "uni.sdk";
                String sdk = this.getProject().getProperty(prop);
                String defaultMin = "10.3";
                if (sdk == null) {
                    int ix = sdks.length - 1;
                    sdk = ((File)sdks[ix]).getPath();
                    if (sdk.indexOf("10.6") != -1 && ix > 0) {
                        sdk = ((File)sdks[ix - 1]).getPath();
                        defaultMin = "10.5";
                    }
                    this.getProject().setProperty(prop, sdk);
                }
                String version = osVers.substring(0, 4);
                int minorVers = Integer.parseInt(osVers.substring(3, 4));
                boolean usingLatestSDK = sdk.indexOf(version) != -1;
                System.out.println("Using SDK=" + sdk);
                if (minorVers >= 6 && ArchName.is64() && usingLatestSDK) {
                    this.getProject().setProperty("jni.cc", "jni-cc");
                    this.getProject().setProperty("uni.arch", "i386");
                    System.out.println("Note: SDK version does not support ppc64");
                }
                prop = "osx.min";
                String min = this.getProject().getProperty(prop);
                if (min == null) {
                    min = defaultMin;
                    this.getProject().setProperty(prop, min);
                }
                System.out.println("Using -mmacosx-version-min=" + min);
            }
        }
        this.getProject().setProperty("jni.scmrev", this.getSourceRevision());
        String home = this.getProject().getProperty("jni.javahome");
        if (home == null) {
            home = System.getProperty("java.home");
        }
        if (!new File(dir = new File(home), "include").exists()) {
            dir = dir.getParentFile();
        }
        this.getProject().setProperty("jni.javahome", dir.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(String filename) {
        FileReader reader = null;
        try {
            reader = new FileReader(filename);
            String string = new BufferedReader(reader).readLine();
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private String getSourceRevision() {
        String exported = "exported";
        String sha1 = this.getGitSourceRevision();
        if (sha1 == null) {
            return "exported";
        }
        return sha1;
    }

    private String getGitSourceRevision() {
        String head;
        String git = this.getProject().getProperty("jni.git");
        if (git == null) {
            git = ".git";
        }
        if (new File(git).exists() && (head = this.readLine(git + "/HEAD")) != null) {
            String sha1;
            String refp = "ref: ";
            if (head.startsWith("ref: ")) {
                String ref = head.substring("ref: ".length()).trim();
                sha1 = this.readLine(git + "/" + ref);
            } else {
                sha1 = head;
            }
            return sha1.substring(0, 7);
        }
        return null;
    }
}

