/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public class SigarInvoker {
    private static HashMap attrCache = new HashMap();
    private static HashMap compatTypes = new HashMap();
    private static HashMap compatAttrs = new HashMap();
    private static final Class[] VOID_SIGNATURE;
    private Class[] ARG_SIGNATURE = new Class[]{String.class};
    private Class[] ARG2_SIGNATURE = new Class[]{String.class, String.class};
    private static final Object[] VOID_ARGS;
    private Object[] ARG_ARGS = new Object[1];
    private String type = null;
    private boolean typeIsArray = false;
    private int arrayIdx = -1;
    private boolean hasArrayIdx = false;
    private int typeArrayType;
    private static final int ARRAY_TYPE_OBJECT = 1;
    private static final int ARRAY_TYPE_DOUBLE = 2;
    private static final int ARRAY_TYPE_LONG = 3;
    private Method typeMethod;
    private SigarProxy sigarProxy;
    private SigarProxyCache handler;

    protected SigarInvoker() {
    }

    public SigarInvoker(SigarProxy proxy, String type) {
        this.setProxy(proxy);
        this.setType(type);
    }

    protected void setProxy(SigarProxy proxy) {
        try {
            this.handler = (SigarProxyCache)Proxy.getInvocationHandler(proxy);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.sigarProxy = proxy;
    }

    public void setType(String val) {
        String alias = (String)compatTypes.get(val);
        if (alias != null) {
            val = alias;
        }
        this.type = val;
    }

    public String getType() {
        return this.type;
    }

    private int getAttributeIndex(String attr) {
        try {
            return Integer.valueOf(attr);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method getTypeMethod(Object[] args) throws SigarException {
        if (this.typeMethod != null) return this.typeMethod;
        Class[] sig = VOID_SIGNATURE;
        boolean argIsArrayIdx = false;
        int argLength = 0;
        String getter = "get" + this.getType();
        if (args != null) {
            argLength = args.length;
            switch (argLength) {
                case 1: {
                    sig = this.ARG_SIGNATURE;
                    break;
                }
                case 2: {
                    sig = this.ARG2_SIGNATURE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        try {
            this.typeMethod = Sigar.class.getMethod(getter, sig);
        }
        catch (Exception e) {
            try {
                this.typeMethod = Sigar.class.getMethod(getter, VOID_SIGNATURE);
                if (argLength == 1) {
                    argIsArrayIdx = true;
                }
            }
            catch (Exception e2) {
                String msg = "Unable to determine getter for " + this.type;
                throw new SigarException(msg);
            }
        }
        Class<?> typeClass = this.typeMethod.getReturnType();
        if (typeClass.isArray()) {
            Class<?> componentClass;
            this.typeIsArray = true;
            if (argIsArrayIdx) {
                try {
                    this.arrayIdx = Integer.parseInt((String)args[0]);
                }
                catch (NumberFormatException ne) {
                    String msg = this.getType() + ": '" + args[0] + "' is not a number";
                    throw new SigarException(msg);
                }
                this.hasArrayIdx = true;
            }
            if ((componentClass = typeClass.getComponentType()).isPrimitive()) {
                if (componentClass == Double.TYPE) {
                    this.typeArrayType = 2;
                    return this.typeMethod;
                } else {
                    if (componentClass != Long.TYPE) throw new SigarException("unsupported array type: " + componentClass.getName());
                    this.typeArrayType = 3;
                }
                return this.typeMethod;
            } else {
                this.typeArrayType = 1;
            }
            return this.typeMethod;
        }
        this.typeIsArray = false;
        return this.typeMethod;
    }

    public Object invoke(Object arg, String attr) throws SigarException, SigarNotImplementedException, SigarPermissionDeniedException {
        Object[] args = null;
        if (arg != null) {
            args = this.ARG_ARGS;
            args[0] = arg;
        }
        return this.invoke(args, attr);
    }

    private String aobMsg(int idx, int length) {
        return "Array index " + idx + " out of bounds " + length;
    }

    public Object invoke(Object[] args, String attr) throws SigarException, SigarNotImplementedException, SigarPermissionDeniedException {
        Object typeObject;
        Method typeGetter = this.getTypeMethod(args);
        if (this.hasArrayIdx) {
            args = null;
        }
        try {
            typeObject = this.handler.invoke(this.sigarProxy, typeGetter, args);
        }
        catch (Throwable t) {
            String parms = args == null ? "" : Arrays.asList(args).toString();
            String msg = "Failed to invoke " + typeGetter.getName() + parms + ": " + t.getMessage();
            if (t instanceof SigarNotImplementedException) {
                throw (SigarNotImplementedException)t;
            }
            if (t instanceof SigarPermissionDeniedException) {
                throw (SigarPermissionDeniedException)t;
            }
            throw new SigarException(msg);
        }
        if (attr == null) {
            return typeObject;
        }
        if (this.typeIsArray) {
            if (this.hasArrayIdx) {
                Object[] array = (Object[])typeObject;
                if (this.arrayIdx >= array.length) {
                    throw new SigarException(this.aobMsg(this.arrayIdx, array.length));
                }
                typeObject = array[this.arrayIdx];
            } else {
                int idx = this.getAttributeIndex(attr);
                if (idx < 0) {
                    throw new SigarException("Invalid array index: " + attr);
                }
                switch (this.typeArrayType) {
                    case 2: {
                        double[] d_array = (double[])typeObject;
                        if (idx >= d_array.length) {
                            throw new SigarException(this.aobMsg(idx, d_array.length));
                        }
                        return new Double(d_array[idx]);
                    }
                    case 3: {
                        long[] l_array = (long[])typeObject;
                        if (idx >= l_array.length) {
                            throw new SigarException(this.aobMsg(idx, l_array.length));
                        }
                        return new Long(l_array[idx]);
                    }
                    case 1: {
                        Object[] o_array = (Object[])typeObject;
                        if (idx >= o_array.length) {
                            throw new SigarException(this.aobMsg(idx, o_array.length));
                        }
                        return o_array[idx];
                    }
                }
            }
        }
        Method attrGetter = this.getAttributeMethod(attr);
        try {
            return attrGetter.invoke(typeObject, VOID_ARGS);
        }
        catch (Throwable t) {
            throw new SigarException(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getAttributeMethod(String attr) throws SigarException {
        Method attrMethod;
        HashMap<String, Method> attrs;
        String alias = (String)compatAttrs.get(attr);
        if (alias != null) {
            attr = alias;
        }
        Class<?> type = this.getTypeMethod(null).getReturnType();
        if (this.hasArrayIdx) {
            type = type.getComponentType();
        }
        HashMap<String, Method> hashMap = attrCache;
        synchronized (hashMap) {
            attrs = (HashMap<String, Method>)attrCache.get(type);
            if (attrs == null) {
                attrs = new HashMap<String, Method>();
                attrCache.put(type, attrs);
            } else {
                attrMethod = (Method)attrs.get(attr);
                if (attrMethod != null) {
                    return attrMethod;
                }
            }
        }
        try {
            attrMethod = type.getMethod("get" + attr, VOID_SIGNATURE);
        }
        catch (Exception e) {
            String msg = "Failed to invoke get" + attr + ": " + e.getMessage();
            throw new SigarException(msg);
        }
        hashMap = attrs;
        synchronized (hashMap) {
            attrs.put(attr, attrMethod);
        }
        return attrMethod;
    }

    static {
        compatTypes.put("NetIfconfig", "NetInterfaceConfig");
        compatTypes.put("NetIfstat", "NetInterfaceStat");
        compatTypes.put("DirStats", "DirStat");
        compatAttrs.put("Utime", "User");
        compatAttrs.put("Stime", "Sys");
        VOID_SIGNATURE = new Class[0];
        VOID_ARGS = new Object[0];
    }
}

