/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.metamx.common.BufferUtils;
import com.metamx.common.FileUtils;
import com.metamx.common.MappedByteBufferHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testMap() throws IOException {
        File dataFile = this.folder.newFile("data");
        long buffersMemoryBefore = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
            raf.write(42);
            raf.setLength(0x100000L);
        }
        var5_5 = null;
        try (MappedByteBufferHandler mappedByteBufferHandler = FileUtils.map((File)dataFile);){
            Assert.assertEquals((long)42L, (long)mappedByteBufferHandler.get().get(0));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        long buffersMemoryAfter = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        Assert.assertEquals((long)buffersMemoryBefore, (long)buffersMemoryAfter);
    }
}

