/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.SequenceTestHelper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class BaseSequenceTest {
    @Test
    public void testSanity() throws Exception {
        List<Integer> vals = Arrays.asList(1, 2, 3, 4, 5);
        SequenceTestHelper.testAll((Sequence<Integer>)BaseSequence.simple(vals), vals);
    }

    @Test
    public void testNothing() throws Exception {
        List<Integer> vals = Arrays.asList(new Integer[0]);
        SequenceTestHelper.testAll((Sequence<Integer>)BaseSequence.simple(vals), vals);
    }

    @Test
    public void testExceptionThrownInIterator() throws Exception {
        final AtomicInteger closedCounter = new AtomicInteger(0);
        BaseSequence seq = new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return new Iterator<Integer>(){

                    @Override
                    public boolean hasNext() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Integer next() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
                closedCounter.incrementAndGet();
            }
        });
        SequenceTestHelper.testClosed(closedCounter, (Sequence<Integer>)seq);
    }
}

