/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.metamx.common.guava.FunctionalIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class FunctionalIteratorTest {
    @Test
    public void testTransform() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterator)FunctionalIterator.create(Arrays.asList("1", "2", "3").iterator()).transform((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.parseInt(input);
            }
        })), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testTransformCat() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterator)FunctionalIterator.create(Arrays.asList("1,2", "3,4", "5,6").iterator()).transformCat((Function)new Function<String, Iterator<String>>(){

            public Iterator<String> apply(String input) {
                return Splitter.on((String)",").split((CharSequence)input).iterator();
            }
        })), Arrays.asList("1", "2", "3", "4", "5", "6"));
    }

    @Test
    public void testKeep() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterator)FunctionalIterator.create(Arrays.asList("1", "2", "3").iterator()).keep((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                if ("2".equals(input)) {
                    return null;
                }
                return Integer.parseInt(input);
            }
        })), Arrays.asList(1, 3));
    }

    @Test
    public void testFilter() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterator)FunctionalIterator.create(Arrays.asList("1", "2", "3").iterator()).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !"2".equals(input);
            }
        })), Arrays.asList("1", "3"));
    }

    @Test
    public void testDrop() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterator)FunctionalIterator.create(Arrays.asList("1", "2", "3").iterator()).drop(2)), Arrays.asList("3"));
    }
}

