/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.SequenceTestHelper;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.UnsupportedSequence;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ResourceClosingSequenceTest {
    @Test
    public void testSanity() throws Exception {
        final AtomicInteger closedCounter = new AtomicInteger(0);
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                closedCounter.incrementAndGet();
            }
        };
        List<Integer> nums = Arrays.asList(1, 2, 3, 4, 5);
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.withBaggage((Sequence)Sequences.simple(nums), (Closeable)closeable), nums);
        Assert.assertEquals((long)3L, (long)closedCounter.get());
        closedCounter.set(0);
        SequenceTestHelper.testClosed(closedCounter, (Sequence<Integer>)Sequences.withBaggage((Sequence)new UnsupportedSequence(), (Closeable)closeable));
    }
}

