/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.parsers.CSVParser;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class CSVParserTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidHeader() {
        String csv = "time,value1,value2";
        boolean parseable = true;
        try {
            CSVParser csvParser = new CSVParser(Optional.fromNullable(null), csv);
        }
        catch (Exception e) {
            parseable = false;
        }
        finally {
            Assert.assertTrue((boolean)parseable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidHeader() {
        String csv = "time,value1,value2,value2";
        boolean parseable = true;
        try {
            CSVParser csvParser = new CSVParser(Optional.fromNullable(null), csv);
        }
        catch (Exception e) {
            parseable = false;
        }
        finally {
            Assert.assertFalse((boolean)parseable);
        }
    }

    @Test
    public void testCSVParserWithHeader() {
        String header = "time,value1,value2";
        CSVParser csvParser = new CSVParser(Optional.fromNullable(null), header);
        String body = "hello,world,foo";
        Map jsonMap = csvParser.parse(body);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"value1", (Object)"world", (Object)"value2", (Object)"foo"), (Object)jsonMap);
    }

    @Test
    public void testCSVParserWithoutHeader() {
        CSVParser csvParser = new CSVParser(Optional.fromNullable(null));
        String body = "hello,world,foo";
        Map jsonMap = csvParser.parse(body);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"column_1", (Object)"hello", (Object)"column_2", (Object)"world", (Object)"column_3", (Object)"foo"), (Object)jsonMap);
    }
}

