/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.parsers.DelimitedParser;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class DelimitedParserTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidHeader() {
        String tsv = "time\tvalue1\tvalue2";
        boolean parseable = true;
        try {
            DelimitedParser delimitedParser = new DelimitedParser(Optional.of((Object)"\t"), Optional.absent(), tsv);
        }
        catch (Exception e) {
            parseable = false;
        }
        finally {
            Assert.assertTrue((boolean)parseable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidHeader() {
        String tsv = "time\tvalue1\tvalue2\tvalue2";
        boolean parseable = true;
        try {
            DelimitedParser delimitedParser = new DelimitedParser(Optional.of((Object)"\t"), Optional.absent(), tsv);
        }
        catch (Exception e) {
            parseable = false;
        }
        finally {
            Assert.assertFalse((boolean)parseable);
        }
    }

    @Test
    public void testTSVParserWithHeader() {
        String header = "time\tvalue1\tvalue2";
        DelimitedParser delimitedParser = new DelimitedParser(Optional.of((Object)"\t"), Optional.absent(), header);
        String body = "hello\tworld\tfoo";
        Map jsonMap = delimitedParser.parse(body);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"value1", (Object)"world", (Object)"value2", (Object)"foo"), (Object)jsonMap);
    }

    @Test
    public void testTSVParserWithoutHeader() {
        DelimitedParser delimitedParser = new DelimitedParser(Optional.of((Object)"\t"), Optional.absent());
        String body = "hello\tworld\tfoo";
        Map jsonMap = delimitedParser.parse(body);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"column_1", (Object)"hello", (Object)"column_2", (Object)"world", (Object)"column_3", (Object)"foo"), (Object)jsonMap);
    }
}

