/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.parsers.JSONParser;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class JSONParserTest {
    private static final String json = "{\"one\": \"foo\", \"two\" : [\"bar\", \"baz\"], \"three\" : \"qux\", \"four\" : null}";
    private static final String numbersJson = "{\"five\" : 5.0, \"six\" : 6, \"many\" : 1234567878900, \"toomany\" : 1234567890000000000000}";
    private static final String whackyCharacterJson = "{\"one\": \"foo\\uD900\"}";

    @Test
    public void testSimple() {
        JSONParser jsonParser = new JSONParser();
        Map jsonMap = jsonParser.parse(json);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo", (Object)"two", (Object)ImmutableList.of((Object)"bar", (Object)"baz"), (Object)"three", (Object)"qux"), (Object)jsonMap);
    }

    @Test
    public void testSimpleWithFields() {
        JSONParser jsonParser = new JSONParser(new ObjectMapper(), (Iterable)Lists.newArrayList((Object[])new String[]{"two"}));
        Map jsonMap = jsonParser.parse(json);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"two", (Object)ImmutableList.of((Object)"bar", (Object)"baz")), (Object)jsonMap);
    }

    @Test
    public void testSimpleWithExclude() {
        JSONParser jsonParser = new JSONParser(new ObjectMapper(), null, (Iterable)Lists.newArrayList((Object[])new String[]{"two"}));
        Map jsonMap = jsonParser.parse(json);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo", (Object)"three", (Object)"qux"), (Object)jsonMap);
    }

    @Test
    public void testWithWhackyCharacters() {
        JSONParser jsonParser = new JSONParser();
        Map jsonMap = jsonParser.parse(whackyCharacterJson);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo?"), (Object)jsonMap);
    }

    @Test
    public void testWithFields() {
        JSONParser jsonParser = new JSONParser();
        jsonParser.setFieldNames((Iterable)ImmutableList.of((Object)"two", (Object)"three", (Object)"five"));
        Map jsonMap = jsonParser.parse(json);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"two", (Object)ImmutableList.of((Object)"bar", (Object)"baz"), (Object)"three", (Object)"qux"), (Object)jsonMap);
    }

    @Test
    public void testWithNumbers() {
        JSONParser jsonParser = new JSONParser();
        Map jsonMap = jsonParser.parse(numbersJson);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"five", (Object)5.0, (Object)"six", (Object)6L, (Object)"many", (Object)1234567878900L, (Object)"toomany", (Object)1.23456789E21), (Object)jsonMap);
    }
}

