/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.parsers.JavaScriptParser;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptParserTest {
    @Test
    public void testParse() {
        String function = "function(str) { var parts = str.split(\"-\"); return { one: parts[0], two: parts[1] } }";
        JavaScriptParser parser = new JavaScriptParser("function(str) { var parts = str.split(\"-\"); return { one: parts[0], two: parts[1] } }");
        String data = "foo-val1";
        Map parsed = parser.parse(data);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"one", (Object)"foo");
        builder.put((Object)"two", (Object)"val1");
        Assert.assertEquals((String)"result", (Object)builder.build(), (Object)parsed);
    }

    @Test
    public void testParseWithMultiVal() {
        String function = "function(str) { var parts = str.split(\"-\"); return { one: [parts[0], parts[1]] } }";
        JavaScriptParser parser = new JavaScriptParser("function(str) { var parts = str.split(\"-\"); return { one: [parts[0], parts[1]] } }");
        String data = "val1-val2";
        Map parsed = parser.parse(data);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"one", (Object)Lists.newArrayList((Object[])new String[]{"val1", "val2"}));
        Assert.assertEquals((String)"result", (Object)builder.build(), (Object)parsed);
    }

    @Test(expected=EvaluatorException.class)
    public void testFailure() {
        String function = "i am bad javascript";
        new JavaScriptParser("i am bad javascript");
    }
}

