/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.primitives.Ints;
import com.metamx.emitter.core.Batch;
import com.metamx.emitter.core.BatchingStrategy;
import com.metamx.emitter.core.EmitterTest;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.core.GoHandler;
import com.metamx.emitter.core.GoHandlers;
import com.metamx.emitter.core.HttpEmitterConfig;
import com.metamx.emitter.core.HttpPostEmitter;
import com.metamx.emitter.core.IntEvent;
import com.metamx.emitter.core.MockHttpClient;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpEmitterTest {
    private final MockHttpClient httpClient = new MockHttpClient();
    private static final ObjectMapper objectMapper = new ObjectMapper(){

        public byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
            return Ints.toByteArray((int)((IntEvent)value).index);
        }
    };
    private final AtomicLong timeoutUsed = new AtomicLong();

    @Before
    public void setup() {
        this.timeoutUsed.set(-1L);
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                int timeout = request.getRequestTimeout();
                HttpEmitterTest.this.timeoutUsed.set(timeout);
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        });
    }

    @Test
    public void timeoutEmptyQueue() throws IOException, InterruptedException {
        HttpEmitterConfig config = new HttpEmitterConfig.Builder("http://foo.bar").setBatchingStrategy(BatchingStrategy.ONLY_EVENTS).setHttpTimeoutAllowanceFactor(2.0f).build();
        HttpPostEmitter emitter = new HttpPostEmitter(config, (AsyncHttpClient)this.httpClient, objectMapper);
        emitter.start();
        emitter.emitAndReturnBatch((Event)new IntEvent());
        emitter.flush();
        Assert.assertTrue((this.timeoutUsed.get() < 5L ? 1 : 0) != 0);
        Batch batch = emitter.emitAndReturnBatch((Event)new IntEvent());
        Thread.sleep(1000L);
        batch.seal();
        emitter.flush();
        Assert.assertTrue((this.timeoutUsed.get() >= 2000L && this.timeoutUsed.get() < 3000L ? 1 : 0) != 0);
    }
}

