/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.metamx.emitter.core.Emitters;
import com.metamx.emitter.core.LoggingEmitter;
import com.metamx.emitter.core.LoggingEmitterConfig;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class LoggingEmitterConfigTest {
    @Test
    public void testDefaults() {
        Properties props = new Properties();
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)LoggingEmitter.class.getName(), (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"info", (Object)config.getLogLevel());
    }

    @Test
    public void testDefaultsLegacy() {
        Properties props = new Properties();
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeLoggingMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)LoggingEmitter.class.getName(), (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"debug", (Object)config.getLogLevel());
    }

    @Test
    public void testSettingEverything() {
        Properties props = new Properties();
        props.setProperty("com.metamx.emitter.loggerClass", "Foo");
        props.setProperty("com.metamx.emitter.logLevel", "INFO");
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)"Foo", (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"INFO", (Object)config.getLogLevel());
    }

    @Test
    public void testSettingEverythingLegacy() {
        Properties props = new Properties();
        props.setProperty("com.metamx.emitter.logging.class", "Foo");
        props.setProperty("com.metamx.emitter.logging.level", "INFO");
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeLoggingMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)"Foo", (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"INFO", (Object)config.getLogLevel());
    }
}

