/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client;

import com.google.common.base.Charsets;
import com.google.common.util.concurrent.ListenableFuture;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.HttpClientConfig;
import com.metamx.http.client.HttpClientInit;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JankyServersTest {
    static ExecutorService exec;
    static ServerSocket silentServerSocket;
    static ServerSocket echoServerSocket;
    static ServerSocket closingServerSocket;

    @BeforeClass
    public static void setUp() throws Exception {
        exec = Executors.newCachedThreadPool();
        silentServerSocket = new ServerSocket(0);
        echoServerSocket = new ServerSocket(0);
        closingServerSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = silentServerSocket.accept();
                        Throwable throwable = null;
                        try {
                            InputStream in = clientSocket.getInputStream();
                            Throwable throwable2 = null;
                            try {
                                while (in.read() != -1) {
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (clientSocket == null) continue;
                            if (throwable != null) {
                                try {
                                    clientSocket.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = closingServerSocket.accept();
                        Throwable throwable = null;
                        try {
                            InputStream in = clientSocket.getInputStream();
                            Throwable throwable2 = null;
                            try {
                                in.read();
                                clientSocket.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (clientSocket == null) continue;
                            if (throwable != null) {
                                try {
                                    clientSocket.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = echoServerSocket.accept();
                        Throwable throwable = null;
                        try {
                            OutputStream out = clientSocket.getOutputStream();
                            Throwable throwable2 = null;
                            try {
                                InputStream in = clientSocket.getInputStream();
                                Throwable throwable3 = null;
                                try {
                                    int b;
                                    while ((b = in.read()) != -1) {
                                        out.write(b);
                                    }
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (in == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    in.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (out == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                out.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (clientSocket == null) continue;
                            if (throwable != null) {
                                try {
                                    clientSocket.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @AfterClass
    public static void tearDown() throws Exception {
        exec.shutdownNow();
        silentServerSocket.close();
        echoServerSocket.close();
        closingServerSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpSilentServerWithGlobalTimeout() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withReadTimeout(new Duration(100L)).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture future = client.go(new Request(HttpMethod.GET, new URL(String.format("http://localhost:%d/", silentServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable e = null;
            try {
                future.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"ReadTimeoutException thrown by 'get'", (boolean)(e instanceof ReadTimeoutException));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpSilentServerWithRequestTimeout() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withReadTimeout(new Duration(31536000L)).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture future = client.go(new Request(HttpMethod.GET, new URL(String.format("http://localhost:%d/", silentServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8), new Duration(100L));
            Throwable e = null;
            try {
                future.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"ReadTimeoutException thrown by 'get'", (boolean)(e instanceof ReadTimeoutException));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsSilentServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).withSslHandshakeTimeout(new Duration(100L)).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(String.format("https://localhost:%d/", silentServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)(e instanceof ChannelException));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpConnectionClosingServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(String.format("http://localhost:%d/", closingServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
                e1.printStackTrace();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)this.isChannelClosedException(e));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsConnectionClosingServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(String.format("https://localhost:%d/", closingServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
                e1.printStackTrace();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)this.isChannelClosedException(e));
        }
        finally {
            lifecycle.stop();
        }
    }

    public boolean isChannelClosedException(Throwable e) {
        return e instanceof ChannelException || e instanceof IOException && e.getMessage().matches(".*Connection reset by peer.*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpEchoServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(String.format("http://localhost:%d/", echoServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"IllegalArgumentException thrown by 'get'", (boolean)(e instanceof IllegalArgumentException));
            Assert.assertTrue((String)"Expected error message", (boolean)e.getMessage().matches(".*invalid version format:.*"));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsEchoServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(String.format("https://localhost:%d/", echoServerSocket.getLocalPort()))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertNotNull((String)"ChannelException thrown by 'get'", (Object)e);
        }
        finally {
            lifecycle.stop();
        }
    }
}

