/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.Monitor;
import com.metamx.metrics.Monitors;
import com.metamx.metrics.StubServiceEmitter;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MonitorsTest {
    @Test
    public void testSetFeed() {
        String feed = "testFeed";
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        Monitor m = Monitors.createCompoundJvmMonitor((Map)ImmutableMap.of(), (String)feed);
        m.start();
        m.monitor((ServiceEmitter)emitter);
        m.stop();
        this.checkEvents(emitter.getEvents(), feed);
    }

    @Test
    public void testDefaultFeed() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        Monitor m = Monitors.createCompoundJvmMonitor((Map)ImmutableMap.of());
        m.start();
        m.monitor((ServiceEmitter)emitter);
        m.stop();
        this.checkEvents(emitter.getEvents(), "metrics");
    }

    private void checkEvents(List<Event> events, String expectedFeed) {
        Assert.assertFalse((String)"no events emitted", (boolean)events.isEmpty());
        for (Event e : events) {
            if (expectedFeed.equals(e.getFeed())) continue;
            String message = String.format("\"feed\" in event: %s", e.toMap().toString());
            Assert.assertEquals((String)message, (Object)expectedFeed, (Object)e.getFeed());
        }
    }
}

