/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics.cgroups;

import com.google.common.collect.ImmutableSet;
import com.metamx.metrics.cgroups.CgroupDiscoverer;
import com.metamx.metrics.cgroups.ProcCgroupDiscoverer;
import com.metamx.metrics.cgroups.TestUtils;
import java.io.File;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class ProcCgroupDiscovererTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws Exception {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
    }

    @Test
    public void testSimpleProc() throws Exception {
        Assert.assertEquals((Object)new File(this.cgroupDir, "cpu,cpuacct/system.slice/mesos-agent-druid.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee").toPath(), (Object)this.discoverer.discover("cpu"));
    }

    @Test
    public void testParse() throws Exception {
        ProcCgroupDiscoverer.ProcMountsEntry entry = ProcCgroupDiscoverer.ProcMountsEntry.parse((String)"/dev/md126 /ebs xfs rw,seclabel,noatime,attr2,inode64,sunit=1024,swidth=16384,noquota 0 0");
        Assert.assertEquals((Object)"/dev/md126", (Object)entry.dev);
        Assert.assertEquals((Object)Paths.get("/ebs", new String[0]), (Object)entry.path);
        Assert.assertEquals((Object)"xfs", (Object)entry.type);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"rw", (Object)"seclabel", (Object)"noatime", (Object)"attr2", (Object)"inode64", (Object)"sunit=1024", (Object[])new String[]{"swidth=16384", "noquota"}), (Object)entry.options);
    }

    @Test
    public void testNullCgroup() {
        this.expectedException.expect(NullPointerException.class);
        Assert.assertNull((Object)new ProcCgroupDiscoverer(this.procDir.toPath()).discover(null));
    }
}

