/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.core.HttpPostEmitter;
import com.metamx.emitter.core.ParametrizedUriEmitter;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.FeedDefiningMonitor;
import com.metamx.metrics.HttpPostEmitterMonitor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class ParametrizedUriEmitterMonitor
extends FeedDefiningMonitor {
    private final ParametrizedUriEmitter parametrizedUriEmitter;
    private final Map<URI, HttpPostEmitterMonitor> monitors = new HashMap<URI, HttpPostEmitterMonitor>();

    public ParametrizedUriEmitterMonitor(String feed, ParametrizedUriEmitter parametrizedUriEmitter) {
        super(feed);
        this.parametrizedUriEmitter = parametrizedUriEmitter;
    }

    private void updateMonitors() {
        this.parametrizedUriEmitter.forEachEmitter((uri, emitter) -> this.monitors.computeIfAbsent((URI)uri, u -> {
            HttpPostEmitterMonitor monitor = new HttpPostEmitterMonitor(this.feed, (HttpPostEmitter)emitter, (ImmutableMap<String, String>)ImmutableMap.of((Object)"uri", (Object)uri.toString()));
            monitor.start();
            return monitor;
        }));
    }

    @Override
    public void stop() {
        this.monitors.values().forEach(AbstractMonitor::stop);
        super.stop();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.updateMonitors();
        this.monitors.values().forEach(m -> m.doMonitor(emitter));
        return true;
    }
}

