/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.leveldbjni.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.JniDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.junit.Test;

public class DBTest
extends TestCase {
    DBFactory factory = JniDBFactory.factory;

    File getTestDirectory(String name) throws IOException {
        File rc = new File(new File("test-data"), name);
        this.factory.destroy(rc, new Options().createIfMissing(true));
        rc.mkdirs();
        return rc;
    }

    @Test
    public void testOpen() throws IOException {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        db.close();
        options = new Options().errorIfExists(true);
        try {
            this.factory.open(path, options);
            DBTest.fail((String)"Expected exception.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRepair() throws IOException, DBException {
        this.testCRUD();
        this.factory.repair(new File(new File("test-data"), this.getName()), new Options());
    }

    @Test
    public void testCRUD() throws IOException, DBException {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        WriteOptions wo = new WriteOptions().sync(false);
        ReadOptions ro = new ReadOptions().fillCache(true).verifyChecksums(true);
        db.put(JniDBFactory.bytes((String)"Tampa"), JniDBFactory.bytes((String)"green"));
        db.put(JniDBFactory.bytes((String)"London"), JniDBFactory.bytes((String)"red"));
        db.put(JniDBFactory.bytes((String)"New York"), JniDBFactory.bytes((String)"blue"));
        this.assertEquals(db.get(JniDBFactory.bytes((String)"Tampa"), ro), JniDBFactory.bytes((String)"green"));
        this.assertEquals(db.get(JniDBFactory.bytes((String)"London"), ro), JniDBFactory.bytes((String)"red"));
        this.assertEquals(db.get(JniDBFactory.bytes((String)"New York"), ro), JniDBFactory.bytes((String)"blue"));
        db.delete(JniDBFactory.bytes((String)"New York"), wo);
        DBTest.assertNull((Object)db.get(JniDBFactory.bytes((String)"New York"), ro));
        db.delete(JniDBFactory.bytes((String)"New York"), wo);
        db.close();
    }

    @Test
    public void testIterator() throws IOException, DBException {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        db.put(JniDBFactory.bytes((String)"Tampa"), JniDBFactory.bytes((String)"green"));
        db.put(JniDBFactory.bytes((String)"London"), JniDBFactory.bytes((String)"red"));
        db.put(JniDBFactory.bytes((String)"New York"), JniDBFactory.bytes((String)"blue"));
        ArrayList<String> expecting = new ArrayList<String>();
        expecting.add("London");
        expecting.add("New York");
        expecting.add("Tampa");
        ArrayList<String> actual = new ArrayList<String>();
        DBIterator iterator = db.iterator();
        iterator.seekToFirst();
        while (iterator.hasNext()) {
            actual.add(JniDBFactory.asString((byte[])((byte[])iterator.peekNext().getKey())));
            iterator.next();
        }
        iterator.close();
        DBTest.assertEquals(expecting, actual);
        db.close();
    }

    @Test
    public void testSnapshot() throws IOException, DBException {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        db.put(JniDBFactory.bytes((String)"Tampa"), JniDBFactory.bytes((String)"green"));
        db.put(JniDBFactory.bytes((String)"London"), JniDBFactory.bytes((String)"red"));
        db.delete(JniDBFactory.bytes((String)"New York"));
        ReadOptions ro = new ReadOptions().snapshot(db.getSnapshot());
        db.put(JniDBFactory.bytes((String)"New York"), JniDBFactory.bytes((String)"blue"));
        this.assertEquals(db.get(JniDBFactory.bytes((String)"Tampa"), ro), JniDBFactory.bytes((String)"green"));
        this.assertEquals(db.get(JniDBFactory.bytes((String)"London"), ro), JniDBFactory.bytes((String)"red"));
        DBTest.assertNull((Object)db.get(JniDBFactory.bytes((String)"New York"), ro));
        ro.snapshot().close();
        ro.snapshot(null);
        this.assertEquals(db.get(JniDBFactory.bytes((String)"New York"), ro), JniDBFactory.bytes((String)"blue"));
        db.close();
    }

    @Test
    public void testWriteBatch() throws IOException, DBException {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        db.put(JniDBFactory.bytes((String)"NA"), JniDBFactory.bytes((String)"Na"));
        WriteBatch batch = db.createWriteBatch();
        batch.delete(JniDBFactory.bytes((String)"NA"));
        batch.put(JniDBFactory.bytes((String)"Tampa"), JniDBFactory.bytes((String)"green"));
        batch.put(JniDBFactory.bytes((String)"London"), JniDBFactory.bytes((String)"red"));
        batch.put(JniDBFactory.bytes((String)"New York"), JniDBFactory.bytes((String)"blue"));
        db.write(batch);
        batch.close();
        ArrayList<String> expecting = new ArrayList<String>();
        expecting.add("London");
        expecting.add("New York");
        expecting.add("Tampa");
        ArrayList<String> actual = new ArrayList<String>();
        DBIterator iterator = db.iterator();
        iterator.seekToFirst();
        while (iterator.hasNext()) {
            actual.add(JniDBFactory.asString((byte[])((byte[])iterator.peekNext().getKey())));
            iterator.next();
        }
        iterator.close();
        DBTest.assertEquals(expecting, actual);
        db.close();
    }

    @Test
    public void testApproximateSizes() throws IOException, DBException {
        int i;
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        Random r = new Random(0L);
        String data = "";
        for (i = 0; i < 1024; ++i) {
            data = data + (97 + r.nextInt(26));
        }
        for (i = 0; i < 5120; ++i) {
            db.put(JniDBFactory.bytes((String)("row" + i)), JniDBFactory.bytes((String)data));
        }
        long[] approximateSizes = db.getApproximateSizes(new Range[]{new Range(JniDBFactory.bytes((String)"row"), JniDBFactory.bytes((String)"s"))});
        DBTest.assertNotNull((Object)approximateSizes);
        DBTest.assertEquals((int)1, (int)approximateSizes.length);
        DBTest.assertTrue((String)"Wrong size", (approximateSizes[0] > 0L ? 1 : 0) != 0);
        db.close();
    }

    @Test
    public void testGetProperty() throws IOException, DBException {
        int i;
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        Random r = new Random(0L);
        String data = "";
        for (i = 0; i < 1024; ++i) {
            data = data + (97 + r.nextInt(26));
        }
        for (i = 0; i < 5120; ++i) {
            db.put(JniDBFactory.bytes((String)("row" + i)), JniDBFactory.bytes((String)data));
        }
        String stats = db.getProperty("leveldb.stats");
        DBTest.assertNotNull((Object)stats);
        DBTest.assertTrue((boolean)stats.contains("Compactions"));
        db.close();
    }

    @Test
    public void testCustomComparator1() throws IOException, DBException {
        Options options = new Options().createIfMissing(true);
        options.comparator(new DBComparator(){

            public int compare(byte[] key1, byte[] key2) {
                return new String(key1).compareTo(new String(key2));
            }

            public String name() {
                return DBTest.this.getName();
            }

            public byte[] findShortestSeparator(byte[] start, byte[] limit) {
                return start;
            }

            public byte[] findShortSuccessor(byte[] key) {
                return key;
            }
        });
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        ArrayList<String> expecting = new ArrayList<String>();
        for (int i = 0; i < 26; ++i) {
            String t = "" + (char)(97 + i);
            expecting.add(t);
            db.put(JniDBFactory.bytes((String)t), JniDBFactory.bytes((String)t));
        }
        ArrayList<String> actual = new ArrayList<String>();
        DBIterator iterator = db.iterator();
        iterator.seekToFirst();
        while (iterator.hasNext()) {
            actual.add(JniDBFactory.asString((byte[])((byte[])iterator.peekNext().getKey())));
            iterator.next();
        }
        iterator.close();
        DBTest.assertEquals(expecting, actual);
        db.close();
    }

    @Test
    public void testCustomComparator2() throws IOException, DBException {
        Options options = new Options().createIfMissing(true);
        options.comparator(new DBComparator(){

            public int compare(byte[] key1, byte[] key2) {
                return new String(key1).compareTo(new String(key2)) * -1;
            }

            public String name() {
                return DBTest.this.getName();
            }

            public byte[] findShortestSeparator(byte[] start, byte[] limit) {
                return start;
            }

            public byte[] findShortSuccessor(byte[] key) {
                return key;
            }
        });
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        ArrayList<String> expecting = new ArrayList<String>();
        for (int i = 0; i < 26; ++i) {
            String t = "" + (char)(97 + i);
            expecting.add(t);
            db.put(JniDBFactory.bytes((String)t), JniDBFactory.bytes((String)t));
        }
        Collections.reverse(expecting);
        ArrayList<String> actual = new ArrayList<String>();
        DBIterator iterator = db.iterator();
        iterator.seekToFirst();
        while (iterator.hasNext()) {
            actual.add(JniDBFactory.asString((byte[])((byte[])iterator.peekNext().getKey())));
            iterator.next();
        }
        iterator.close();
        DBTest.assertEquals(expecting, actual);
        db.close();
    }

    @Test
    public void testLogger() throws IOException, InterruptedException, DBException {
        final List messages = Collections.synchronizedList(new ArrayList());
        Options options = new Options().createIfMissing(true);
        options.logger(new Logger(){

            public void log(String message) {
                messages.add(message);
            }
        });
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        for (int j = 0; j < 5; ++j) {
            int i;
            Random r = new Random(0L);
            String data = "";
            for (i = 0; i < 1024; ++i) {
                data = data + (97 + r.nextInt(26));
            }
            for (i = 0; i < 5120; ++i) {
                db.put(JniDBFactory.bytes((String)("row" + i)), JniDBFactory.bytes((String)data));
            }
            Thread.sleep(100L);
        }
        db.close();
        DBTest.assertFalse((boolean)messages.isEmpty());
    }

    @Test
    public void testCompactRanges() throws IOException, InterruptedException, DBException {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        if (db instanceof JniDB) {
            int i;
            Random r = new Random(0L);
            String data = "";
            for (i = 0; i < 1024; ++i) {
                data = data + (97 + r.nextInt(26));
            }
            for (i = 0; i < 5120; ++i) {
                db.put(JniDBFactory.bytes((String)("row" + i)), JniDBFactory.bytes((String)data));
            }
            for (i = 0; i < 5120; ++i) {
                db.delete(JniDBFactory.bytes((String)("row" + i)));
            }
            String stats = db.getProperty("leveldb.stats");
            System.out.println(stats);
            DBTest.assertFalse((boolean)stats.contains("1        0        0         0"));
            DBTest.assertFalse((boolean)stats.contains("2        0        0         0"));
            ((JniDB)db).compactRange(null, null);
            stats = db.getProperty("leveldb.stats");
            System.out.println(stats);
            DBTest.assertTrue((boolean)stats.contains("1        0        0         0"));
            DBTest.assertTrue((boolean)stats.contains("2        0        0         0"));
        }
        db.close();
    }

    @Test
    public void testSuspendAndResumeCompactions() throws Exception {
        Options options = new Options().createIfMissing(true);
        File path = this.getTestDirectory(this.getName());
        DB db = this.factory.open(path, options);
        db.suspendCompactions();
        db.resumeCompactions();
        db.close();
    }

    public void assertEquals(byte[] arg1, byte[] arg2) {
        DBTest.assertTrue((boolean)Arrays.equals(arg1, arg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssue26() throws IOException {
        JniDBFactory.pushMemoryPool((int)524288);
        try {
            Options options = new Options();
            options.createIfMissing(true);
            DB db = this.factory.open(this.getTestDirectory(this.getName()), options);
            for (int i = 0; i < 0x100000; ++i) {
                byte[] key = ByteBuffer.allocate(4).putInt(i).array();
                byte[] value = ByteBuffer.allocate(4).putInt(-i).array();
                db.put(key, value);
                DBTest.assertTrue((boolean)Arrays.equals(db.get(key), value));
            }
            db.close();
        }
        finally {
            JniDBFactory.popMemoryPool();
        }
    }

    @Test
    public void testIssue27() throws IOException {
        Options options = new Options();
        options.createIfMissing(true);
        DB db = this.factory.open(this.getTestDirectory(this.getName()), options);
        db.close();
        try {
            db.iterator();
            DBTest.fail((String)"Expected a DBException");
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }
}

