/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(35L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(11L),
    EAGAIN(11L),
    EINPROGRESS(115L),
    EALREADY(114L),
    ENOTSOCK(88L),
    EDESTADDRREQ(89L),
    EMSGSIZE(90L),
    EPROTOTYPE(91L),
    ENOPROTOOPT(92L),
    EPROTONOSUPPORT(93L),
    ESOCKTNOSUPPORT(94L),
    EOPNOTSUPP(95L),
    EPFNOSUPPORT(96L),
    EAFNOSUPPORT(97L),
    EADDRINUSE(98L),
    EADDRNOTAVAIL(99L),
    ENETDOWN(100L),
    ENETUNREACH(101L),
    ENETRESET(102L),
    ECONNABORTED(103L),
    ECONNRESET(104L),
    ENOBUFS(105L),
    EISCONN(106L),
    ENOTCONN(107L),
    ESHUTDOWN(108L),
    ETOOMANYREFS(109L),
    ETIMEDOUT(110L),
    ECONNREFUSED(111L),
    ELOOP(40L),
    ENAMETOOLONG(36L),
    EHOSTDOWN(112L),
    EHOSTUNREACH(113L),
    ENOTEMPTY(39L),
    EUSERS(87L),
    EDQUOT(122L),
    ESTALE(116L),
    EREMOTE(66L),
    ENOLCK(37L),
    ENOSYS(38L),
    EOVERFLOW(75L),
    EIDRM(43L),
    ENOMSG(42L),
    EILSEQ(84L),
    EBADMSG(74L),
    EMULTIHOP(72L),
    ENODATA(61L),
    ENOLINK(67L),
    ENOSR(63L),
    ENOSTR(60L),
    EPROTO(71L),
    ETIME(62L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 122L;

    private Errno(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Operation not permitted");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "Input/output error");
            map2.put(ENXIO, "No such device or address");
            map2.put(E2BIG, "Argument list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(ENOMEM, "Cannot allocate memory");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Device or resource busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Invalid cross-device link");
            map2.put(ENODEV, "No such device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate ioctl for device");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Numerical argument out of domain");
            map2.put(ERANGE, "Numerical result out of range");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Protocol not available");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Address family not supported by protocol");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Cannot assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection on reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Transport endpoint is already connected");
            map2.put(ENOTCONN, "Transport endpoint is not connected");
            map2.put(ESHUTDOWN, "Cannot send after transport endpoint shutdown");
            map2.put(ETOOMANYREFS, "Too many references: cannot splice");
            map2.put(ETIMEDOUT, "Connection timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Too many levels of symbolic links");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disk quota exceeded");
            map2.put(ESTALE, "Stale file handle");
            map2.put(EREMOTE, "Object is remote");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Value too large for defined data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Invalid or incomplete multibyte or wide character");
            map2.put(EBADMSG, "Bad message");
            map2.put(EMULTIHOP, "Multihop attempted");
            map2.put(ENODATA, "No data available");
            map2.put(ENOLINK, "Link has been severed");
            map2.put(ENOSR, "Out of streams resources");
            map2.put(ENOSTR, "Device not a stream");
            map2.put(EPROTO, "Protocol error");
            map2.put(ETIME, "Timer expired");
            return map2;
        }
    }
}

