/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import io.airlift.units.Duration;
import io.prestosql.cli.ClientOptions;
import io.prestosql.cli.Completion;
import io.prestosql.cli.Help;
import io.prestosql.cli.LineReader;
import io.prestosql.cli.Query;
import io.prestosql.cli.QueryPreprocessor;
import io.prestosql.cli.QueryPreprocessorException;
import io.prestosql.cli.QueryRunner;
import io.prestosql.cli.TableNameCompleter;
import io.prestosql.cli.ThreadInterruptor;
import io.prestosql.cli.VersionOption;
import io.prestosql.client.ClientSelectedRole;
import io.prestosql.client.ClientSession;
import io.prestosql.sql.parser.StatementSplitter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.inject.Inject;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.internal.Configuration;
import org.fusesource.jansi.AnsiConsole;

@Command(name="presto", description="Presto interactive console")
public class Console {
    private static final String PROMPT_NAME = "presto";
    private static final Duration EXIT_DELAY = new Duration(3.0, TimeUnit.SECONDS);
    private static final Pattern HISTORY_INDEX_PATTERN = Pattern.compile("!\\d+");
    @Inject
    public HelpOption helpOption;
    @Inject
    public VersionOption versionOption = new VersionOption();
    @Inject
    public ClientOptions clientOptions = new ClientOptions();

    public boolean run() {
        boolean isFromFile;
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = !Strings.isNullOrEmpty(this.clientOptions.execute);
        boolean bl = isFromFile = !Strings.isNullOrEmpty(this.clientOptions.file);
        if (!hasQuery && !isFromFile) {
            AnsiConsole.systemInstall();
        }
        Console.initializeLogging(this.clientOptions.logLevelsFile);
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.toString(new File(this.clientOptions.file), StandardCharsets.UTF_8);
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        AtomicBoolean exiting = new AtomicBoolean();
        ThreadInterruptor interruptor = new ThreadInterruptor();
        CountDownLatch exited = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting.set(true);
            interruptor.interrupt();
            Uninterruptibles.awaitUninterruptibly(exited, EXIT_DELAY.toMillis(), TimeUnit.MILLISECONDS);
        }));
        try {
            QueryRunner queryRunner;
            block16: {
                queryRunner = new QueryRunner(session, this.clientOptions.debug, Optional.ofNullable(this.clientOptions.socksProxy), Optional.ofNullable(this.clientOptions.httpProxy), Optional.ofNullable(this.clientOptions.keystorePath), Optional.ofNullable(this.clientOptions.keystorePassword), Optional.ofNullable(this.clientOptions.truststorePath), Optional.ofNullable(this.clientOptions.truststorePassword), Optional.ofNullable(this.clientOptions.accessToken), Optional.ofNullable(this.clientOptions.user), this.clientOptions.password ? Optional.of(this.getPassword()) : Optional.empty(), Optional.ofNullable(this.clientOptions.krb5Principal), Optional.ofNullable(this.clientOptions.krb5ServicePrincipalPattern), Optional.ofNullable(this.clientOptions.krb5RemoteServiceName), Optional.ofNullable(this.clientOptions.krb5ConfigPath), Optional.ofNullable(this.clientOptions.krb5KeytabPath), Optional.ofNullable(this.clientOptions.krb5CredentialCachePath), !this.clientOptions.krb5DisableRemoteServiceHostnameCanonicalization);
                try {
                    if (!hasQuery) break block16;
                    boolean bl2 = Console.executeCommand(queryRunner, exiting, query, this.clientOptions.outputFormat, this.clientOptions.ignoreErrors, this.clientOptions.progress);
                    queryRunner.close();
                    return bl2;
                }
                catch (Throwable throwable) {
                    try {
                        queryRunner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Console.runConsole(queryRunner, exiting);
            boolean bl3 = true;
            queryRunner.close();
            return bl3;
        }
        finally {
            exited.countDown();
            interruptor.close();
        }
    }

    private String getPassword() {
        Preconditions.checkState(this.clientOptions.user != null, "Username must be specified along with password");
        String defaultPassword = System.getenv("PRESTO_PASSWORD");
        if (defaultPassword != null) {
            return defaultPassword;
        }
        java.io.Console console = System.console();
        if (console != null) {
            char[] password = console.readPassword("Password: ", new Object[0]);
            if (password != null) {
                return new String(password);
            }
            return "";
        }
        try {
            ConsoleReader consoleReader = new ConsoleReader(System.in, System.err);
            return consoleReader.readLine("Password: ", Character.valueOf('\u0000'));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to read password from console", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runConsole(QueryRunner queryRunner, AtomicBoolean exiting) {
        try (TableNameCompleter tableNameCompleter = new TableNameCompleter(queryRunner);
             LineReader reader = new LineReader(Console.getHistory(), Completion.commandCompleter(), Completion.lowerCaseCommandCompleter(), tableNameCompleter);){
            tableNameCompleter.populateCache();
            StringBuilder buffer = new StringBuilder();
            block27: while (!exiting.get()) {
                String prompt = PROMPT_NAME;
                String schema = queryRunner.getSession().getSchema();
                if (schema != null) {
                    prompt = prompt + ":" + schema;
                }
                if (buffer.length() > 0) {
                    prompt = Strings.repeat(" ", prompt.length() - 1) + "-";
                }
                String commandPrompt = prompt + "> ";
                String line = reader.readLine(commandPrompt);
                if (reader.interrupted()) {
                    String partial = StatementSplitter.squeezeStatement(buffer.toString());
                    if (!partial.isEmpty()) {
                        reader.getHistory().add(partial);
                    }
                    buffer = new StringBuilder();
                    continue;
                }
                if (line == null) {
                    System.out.println();
                    return;
                }
                if (buffer.length() == 0) {
                    String command = line.trim();
                    if (HISTORY_INDEX_PATTERN.matcher(command).matches()) {
                        int historyIndex = Integer.parseInt(command.substring(1));
                        History history = reader.getHistory();
                        if (historyIndex <= 0 || historyIndex > history.index()) {
                            System.err.println("Command does not exist");
                            continue;
                        }
                        line = history.get(historyIndex - 1).toString();
                        System.out.println(commandPrompt + line);
                    }
                    if (command.endsWith(";")) {
                        command = command.substring(0, command.length() - 1).trim();
                    }
                    switch (command.toLowerCase(Locale.ENGLISH)) {
                        case "exit": 
                        case "quit": {
                            return;
                        }
                        case "history": {
                            Iterator<History.Entry> iterator = reader.getHistory().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block27;
                                History.Entry entry = iterator.next();
                                System.out.printf("%5d  %s%n", entry.index() + 1, entry.value());
                            }
                        }
                        case "help": {
                            System.out.println();
                            System.out.println(Help.getHelpText());
                            continue block27;
                        }
                    }
                }
                buffer.append(line).append("\n");
                String sql = buffer.toString();
                StatementSplitter splitter = new StatementSplitter(sql, ImmutableSet.of(";", "\\G"));
                for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                    ClientOptions.OutputFormat outputFormat = ClientOptions.OutputFormat.ALIGNED;
                    if (split.terminator().equals("\\G")) {
                        outputFormat = ClientOptions.OutputFormat.VERTICAL;
                    }
                    Console.process(queryRunner, split.statement(), outputFormat, tableNameCompleter::populateCache, true, true, System.out, System.out);
                    reader.getHistory().add(StatementSplitter.squeezeStatement(split.statement()) + split.terminator());
                }
                buffer = new StringBuilder();
                String partial = splitter.getPartialStatement();
                if (partial.isEmpty()) continue;
                buffer.append(partial).append('\n');
            }
            return;
        }
        catch (IOException e) {
            System.err.println("Readline error: " + e.getMessage());
        }
    }

    private static boolean executeCommand(QueryRunner queryRunner, AtomicBoolean exiting, String query, ClientOptions.OutputFormat outputFormat, boolean ignoreErrors, boolean showProgress) {
        boolean success = true;
        StatementSplitter splitter = new StatementSplitter(query);
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            if (!StatementSplitter.isEmptyStatement(split.statement()) && !Console.process(queryRunner, split.statement(), outputFormat, () -> {}, false, showProgress, System.out, System.err)) {
                if (!ignoreErrors) {
                    return false;
                }
                success = false;
            }
            if (!exiting.get()) continue;
            return success;
        }
        if (!StatementSplitter.isEmptyStatement(splitter.getPartialStatement())) {
            System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
            return false;
        }
        return success;
    }

    private static boolean process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, Runnable schemaChanged, boolean usePager, boolean showProgress, PrintStream out, PrintStream errorChannel) {
        String finalSql;
        try {
            finalSql = QueryPreprocessor.preprocessQuery(Optional.ofNullable(queryRunner.getSession().getCatalog()), Optional.ofNullable(queryRunner.getSession().getSchema()), sql);
        }
        catch (QueryPreprocessorException e) {
            System.err.println(e.getMessage());
            if (queryRunner.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        Query query = queryRunner.startQuery(finalSql);
        try {
            boolean success = query.renderOutput(out, errorChannel, outputFormat, usePager, showProgress);
            ClientSession session = queryRunner.getSession();
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                session = ClientSession.builder(session).withCatalog(query.getSetCatalog().orElse(session.getCatalog())).withSchema(query.getSetSchema().orElse(session.getSchema())).build();
            }
            if (query.isClearTransactionId()) {
                session = ClientSession.stripTransactionId(session);
            }
            ClientSession.Builder builder = ClientSession.builder(session);
            if (query.getStartedTransactionId() != null) {
                builder = builder.withTransactionId(query.getStartedTransactionId());
            }
            if (query.getSetPath().isPresent()) {
                builder = builder.withPath(query.getSetPath().get());
            }
            if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                HashMap<String, String> sessionProperties = new HashMap<String, String>(session.getProperties());
                sessionProperties.putAll(query.getSetSessionProperties());
                sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                builder = builder.withProperties(sessionProperties);
            }
            if (!query.getSetRoles().isEmpty()) {
                HashMap<String, ClientSelectedRole> roles = new HashMap<String, ClientSelectedRole>(session.getRoles());
                roles.putAll(query.getSetRoles());
                builder = builder.withRoles(roles);
            }
            if (!query.getAddedPreparedStatements().isEmpty() || !query.getDeallocatedPreparedStatements().isEmpty()) {
                HashMap<String, String> preparedStatements = new HashMap<String, String>(session.getPreparedStatements());
                preparedStatements.putAll(query.getAddedPreparedStatements());
                preparedStatements.keySet().removeAll(query.getDeallocatedPreparedStatements());
                builder = builder.withPreparedStatements(preparedStatements);
            }
            session = builder.build();
            queryRunner.setSession(session);
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                schemaChanged.run();
            }
            boolean bl = success;
            if (query != null) {
                query.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (query != null) {
                    try {
                        query.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                System.err.println("Error running command: " + e.getMessage());
                if (queryRunner.isDebug()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
    }

    private static MemoryHistory getHistory() {
        String historyFilePath = System.getenv("PRESTO_HISTORY_FILE");
        File historyFile = Strings.isNullOrEmpty(historyFilePath) ? new File(Configuration.getUserHome(), ".presto_history") : new File(historyFilePath);
        return Console.getHistory(historyFile);
    }

    @VisibleForTesting
    static MemoryHistory getHistory(File historyFile) {
        MemoryHistory history;
        try {
            Files.createParentDirs(historyFile.getParentFile());
            historyFile.createNewFile();
            history = new FileHistory(historyFile);
            history.setMaxSize(10000);
        }
        catch (IOException e) {
            System.err.printf("WARNING: Failed to load history file (%s): %s. History will not be available during this session.%n", historyFile, e.getMessage());
            history = new MemoryHistory();
        }
        history.setAutoTrim(true);
        return history;
    }

    private static void initializeLogging(String logLevelsFile) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            LoggingConfiguration config = new LoggingConfiguration();
            if (logLevelsFile == null) {
                System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
                System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
                config.setConsoleEnabled(false);
            } else {
                config.setLevelsFile(logLevelsFile);
            }
            Logging logging = Logging.initialize();
            logging.configure(config);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }
}

