/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import java.io.PrintStream;
import java.util.Objects;
import jline.TerminalFactory;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.internal.CLibrary;

public class ConsolePrinter {
    public static final boolean REAL_TERMINAL = ConsolePrinter.detectRealTerminal();
    private final PrintStream out;
    private int lines;

    public ConsolePrinter(PrintStream out) {
        this.out = Objects.requireNonNull(out, "out is null");
    }

    public void reprintLine(String line) {
        if (this.isRealTerminal()) {
            this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        } else {
            this.out.print('\r' + line);
        }
        this.out.flush();
        ++this.lines;
    }

    public void repositionCursor() {
        if (this.lines > 0) {
            if (this.isRealTerminal()) {
                this.out.print(Ansi.ansi().cursorUp(this.lines).toString());
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    public void resetScreen() {
        if (this.lines > 0) {
            if (this.isRealTerminal()) {
                this.out.print(Ansi.ansi().cursorUp(this.lines).eraseScreen(Ansi.Erase.FORWARD).toString());
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    public int getWidth() {
        return TerminalFactory.get().getWidth();
    }

    public boolean isRealTerminal() {
        return REAL_TERMINAL;
    }

    private static boolean detectRealTerminal() {
        if (Boolean.parseBoolean(System.getProperty("jansi.passthrough"))) {
            return true;
        }
        if (Boolean.parseBoolean(System.getProperty("jansi.strip"))) {
            return false;
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return true;
        }
        try {
            if (CLibrary.isatty(CLibrary.STDERR_FILENO) == 0) {
                return false;
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError linkageError) {
            // empty catch block
        }
        return true;
    }
}

