/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.parser;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.airlift.log.Logger;
import io.prestosql.sql.parser.ParsingException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.atn.WildcardTransition;
import org.antlr.v4.runtime.misc.IntervalSet;

class ErrorHandler
extends BaseErrorListener {
    private static final Logger LOG = Logger.get(ErrorHandler.class);
    private final Map<Integer, String> specialRules;
    private final Map<Integer, String> specialTokens;
    private final Set<Integer> ignoredRules;

    private ErrorHandler(Map<Integer, String> specialRules, Map<Integer, String> specialTokens, Set<Integer> ignoredRules) {
        this.specialRules = new HashMap<Integer, String>(specialRules);
        this.specialTokens = specialTokens;
        this.ignoredRules = new HashSet<Integer>(ignoredRules);
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        try {
            RuleContext context;
            Token currentToken;
            ATNState currentState;
            Parser parser = (Parser)recognizer;
            ATN atn = parser.getATN();
            if (e != null) {
                currentState = atn.states.get(e.getOffendingState());
                currentToken = e.getOffendingToken();
                context = e.getCtx();
                if (e instanceof NoViableAltException) {
                    currentToken = ((NoViableAltException)e).getStartToken();
                }
            } else {
                currentState = atn.states.get(parser.getState());
                currentToken = parser.getCurrentToken();
                context = parser.getContext();
            }
            Analyzer analyzer = new Analyzer(atn, parser.getVocabulary(), this.specialRules, this.specialTokens, this.ignoredRules, parser.getTokenStream());
            Multimap<Integer, String> candidates = analyzer.process(currentState, currentToken.getTokenIndex(), context);
            String expected = ((Collection)candidates.asMap().entrySet().stream().max(Comparator.comparing(Map.Entry::getKey)).get().getValue()).stream().sorted().collect(Collectors.joining(", "));
            message = String.format("mismatched input '%s'. Expecting: %s", ((Token)offendingSymbol).getText(), expected);
        }
        catch (Exception exception) {
            LOG.error(exception, "Unexpected failure when handling parsing error. This is likely a bug in the implementation");
        }
        throw new ParsingException(message, e, line, charPositionInLine);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Integer, String> specialRules = new HashMap<Integer, String>();
        private final Map<Integer, String> specialTokens = new HashMap<Integer, String>();
        private final Set<Integer> ignoredRules = new HashSet<Integer>();

        public Builder specialRule(int ruleId, String name) {
            this.specialRules.put(ruleId, name);
            return this;
        }

        public Builder specialToken(int tokenId, String name) {
            this.specialTokens.put(tokenId, name);
            return this;
        }

        public Builder ignoredRule(int ruleId) {
            this.ignoredRules.add(ruleId);
            return this;
        }

        public ErrorHandler build() {
            return new ErrorHandler(this.specialRules, this.specialTokens, this.ignoredRules);
        }
    }

    private static class Analyzer {
        private final ATN atn;
        private final Vocabulary vocabulary;
        private final Map<Integer, String> specialRules;
        private final Map<Integer, String> specialTokens;
        private final Set<Integer> ignoredRules;
        private final TokenStream stream;

        public Analyzer(ATN atn, Vocabulary vocabulary, Map<Integer, String> specialRules, Map<Integer, String> specialTokens, Set<Integer> ignoredRules, TokenStream stream) {
            this.stream = stream;
            this.atn = atn;
            this.vocabulary = vocabulary;
            this.specialRules = specialRules;
            this.specialTokens = specialTokens;
            this.ignoredRules = ignoredRules;
        }

        public Multimap<Integer, String> process(ATNState currentState, int tokenIndex, RuleContext context) {
            return this.process(new ParsingState(currentState, tokenIndex, false, this.makeCallStack(context)));
        }

        private Multimap<Integer, String> process(ParsingState start) {
            HashMultimap<Integer, String> candidates = HashMultimap.create();
            ArrayDeque<ParsingState> activeStates = new ArrayDeque<ParsingState>();
            activeStates.add(start);
            while (!activeStates.isEmpty()) {
                ParsingState current = (ParsingState)activeStates.poll();
                ATNState state = current.state;
                int tokenIndex = current.tokenIndex;
                boolean suppressed = current.suppressed;
                CallerContext caller = current.caller;
                while (this.stream.get(tokenIndex).getChannel() == 1) {
                    ++tokenIndex;
                }
                int currentToken = this.stream.get(tokenIndex).getType();
                if (state.getStateType() == 3 || state.getStateType() == 2) {
                    int rule = state.ruleIndex;
                    if (this.specialRules.containsKey(rule)) {
                        if (!suppressed) {
                            candidates.put(tokenIndex, this.specialRules.get(rule));
                        }
                        suppressed = true;
                    } else if (this.ignoredRules.contains(rule)) continue;
                }
                if (state instanceof RuleStopState) {
                    if (caller != null) {
                        activeStates.add(new ParsingState(caller.followState, tokenIndex, suppressed, caller.parent));
                        continue;
                    }
                    if (suppressed) continue;
                    candidates.putAll(tokenIndex, this.getTokenNames(IntervalSet.of(-1)));
                    continue;
                }
                for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
                    Transition transition = state.transition(i);
                    if (transition instanceof RuleTransition) {
                        activeStates.add(new ParsingState(transition.target, tokenIndex, suppressed, new CallerContext(caller, ((RuleTransition)transition).followState)));
                        continue;
                    }
                    if (transition.isEpsilon()) {
                        activeStates.add(new ParsingState(transition.target, tokenIndex, suppressed, caller));
                        continue;
                    }
                    if (transition instanceof WildcardTransition) {
                        throw new UnsupportedOperationException("not yet implemented: wildcard transition");
                    }
                    IntervalSet labels = transition.label();
                    if (transition instanceof NotSetTransition) {
                        labels = labels.complement(IntervalSet.of(1, this.atn.maxTokenType));
                    }
                    if (labels.contains(currentToken)) {
                        activeStates.add(new ParsingState(transition.target, tokenIndex + 1, false, caller));
                        continue;
                    }
                    if (suppressed) continue;
                    candidates.putAll(tokenIndex, this.getTokenNames(labels));
                }
            }
            return candidates;
        }

        private Set<String> getTokenNames(IntervalSet tokens) {
            return tokens.toSet().stream().map(token -> {
                if (token == -1) {
                    return "<EOF>";
                }
                return this.specialTokens.getOrDefault(token, this.vocabulary.getDisplayName((int)token));
            }).collect(Collectors.toSet());
        }

        private CallerContext makeCallStack(RuleContext context) {
            if (context == null || context.invokingState == -1) {
                return null;
            }
            CallerContext parent = this.makeCallStack(context.parent);
            ATNState followState = ((RuleTransition)this.atn.states.get((int)context.invokingState).transition((int)0)).followState;
            return new CallerContext(parent, followState);
        }
    }

    private static class CallerContext {
        public final ATNState followState;
        public final CallerContext parent;

        public CallerContext(CallerContext parent, ATNState followState) {
            this.parent = parent;
            this.followState = followState;
        }
    }

    private static class ParsingState {
        public final ATNState state;
        public final int tokenIndex;
        public final boolean suppressed;
        private final CallerContext caller;

        public ParsingState(ATNState state, int tokenIndex, boolean suppressed, CallerContext caller) {
            this.state = state;
            this.tokenIndex = tokenIndex;
            this.suppressed = suppressed;
            this.caller = caller;
        }
    }
}

