/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CallArgument
extends Node {
    private final Optional<String> name;
    private final Expression value;

    public CallArgument(Expression value) {
        this(Optional.empty(), Optional.empty(), value);
    }

    public CallArgument(NodeLocation location, Expression value) {
        this(Optional.of(location), Optional.empty(), value);
    }

    public CallArgument(String name, Expression value) {
        this(Optional.empty(), Optional.of(name), value);
    }

    public CallArgument(NodeLocation location, String name, Expression value) {
        this(Optional.of(location), Optional.of(name), value);
    }

    public CallArgument(Optional<NodeLocation> location, Optional<String> name, Expression value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCallArgument(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CallArgument o = (CallArgument)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.value, o.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name.orElse(null)).add("value", this.value).omitNullValues().toString();
    }
}

