/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.ExplainOption;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Explain
extends Statement {
    private final Statement statement;
    private final boolean analyze;
    private final boolean verbose;
    private final List<ExplainOption> options;

    public Explain(Statement statement, boolean analyze, boolean verbose, List<ExplainOption> options) {
        this(Optional.empty(), analyze, verbose, statement, options);
    }

    public Explain(NodeLocation location, boolean analyze, boolean verbose, Statement statement, List<ExplainOption> options) {
        this(Optional.of(location), analyze, verbose, statement, options);
    }

    private Explain(Optional<NodeLocation> location, boolean analyze, boolean verbose, Statement statement, List<ExplainOption> options) {
        super(location);
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.analyze = analyze;
        this.verbose = verbose;
        this.options = options == null ? ImmutableList.of() : ImmutableList.copyOf(options);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean isAnalyze() {
        return this.analyze;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public List<ExplainOption> getOptions() {
        return this.options;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    public List<Node> getChildren() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.statement)).addAll(this.options)).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.options, this.analyze);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)obj;
        return Objects.equals(this.statement, o.statement) && Objects.equals(this.options, o.options) && Objects.equals(this.analyze, o.analyze);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("statement", this.statement).add("options", this.options).add("analyze", this.analyze).toString();
    }
}

