/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.ExplainOption;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExplainType
extends ExplainOption {
    private final Type type;

    public ExplainType(Type type) {
        this(Optional.empty(), type);
    }

    public ExplainType(NodeLocation location, Type type) {
        this(Optional.of(location), type);
    }

    private ExplainType(Optional<NodeLocation> location, Type type) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Type getType() {
        return this.type;
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainType o = (ExplainType)obj;
        return Objects.equals((Object)this.type, (Object)o.type);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        LOGICAL,
        DISTRIBUTED,
        VALIDATE,
        IO;

    }
}

