/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final Optional<Window> window;
    private final Optional<Expression> filter;
    private final Optional<OrderBy> orderBy;
    private final boolean distinct;
    private final List<Expression> arguments;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this(Optional.empty(), name, Optional.empty(), Optional.empty(), Optional.empty(), false, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, List<Expression> arguments) {
        this(Optional.of(location), name, Optional.empty(), Optional.empty(), Optional.empty(), false, arguments);
    }

    public FunctionCall(Optional<NodeLocation> location, QualifiedName name, Optional<Window> window, Optional<Expression> filter, Optional<OrderBy> orderBy, boolean distinct, List<Expression> arguments) {
        super(location);
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(window, "window is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(arguments, "arguments is null");
        this.name = name;
        this.window = window;
        this.filter = filter;
        this.orderBy = orderBy;
        this.distinct = distinct;
        this.arguments = arguments;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public Optional<Expression> getFilter() {
        return this.filter;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.window.ifPresent(nodes::add);
        this.filter.ifPresent(nodes::add);
        this.orderBy.map(OrderBy::getSortItems).map(nodes::addAll);
        nodes.addAll(this.arguments);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window) && Objects.equals(this.filter, o.filter) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.distinct, o.distinct) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.window, this.filter, this.orderBy, this.arguments);
    }
}

