/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GroupingElement;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SimpleGroupBy
extends GroupingElement {
    private final List<Expression> columns;

    public SimpleGroupBy(List<Expression> simpleGroupByExpressions) {
        this(Optional.empty(), simpleGroupByExpressions);
    }

    public SimpleGroupBy(NodeLocation location, List<Expression> simpleGroupByExpressions) {
        this(Optional.of(location), simpleGroupByExpressions);
    }

    private SimpleGroupBy(Optional<NodeLocation> location, List<Expression> simpleGroupByExpressions) {
        super(location);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(simpleGroupByExpressions, "simpleGroupByExpressions is null"));
    }

    @Override
    public List<Expression> getExpressions() {
        return this.columns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleGroupBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.columns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleGroupBy that = (SimpleGroupBy)o;
        return Objects.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("columns", this.columns).toString();
    }
}

