/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.WithQuery;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class With
extends Node {
    private final boolean recursive;
    private final List<WithQuery> queries;

    public With(boolean recursive, List<WithQuery> queries) {
        this(Optional.empty(), recursive, queries);
    }

    public With(NodeLocation location, boolean recursive, List<WithQuery> queries) {
        this(Optional.of(location), recursive, queries);
    }

    private With(Optional<NodeLocation> location, boolean recursive, List<WithQuery> queries) {
        super(location);
        Objects.requireNonNull(queries, "queries is null");
        Preconditions.checkArgument(!queries.isEmpty(), "queries is empty");
        this.recursive = recursive;
        this.queries = ImmutableList.copyOf(queries);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public List<WithQuery> getQueries() {
        return this.queries;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWith(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.queries;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        With o = (With)obj;
        return Objects.equals(this.recursive, o.recursive) && Objects.equals(this.queries, o.queries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.recursive, this.queries);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("recursive", this.recursive).add("queries", this.queries).toString();
    }
}

