/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;

public abstract class DecimalMaxValidator<T>
implements ConstraintValidator<DecimalMax, T> {
    private BigDecimal maxValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMax annotation) {
        try {
            this.maxValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
        this.inclusive = annotation.inclusive();
    }

    protected boolean isValid(BigDecimal value) {
        if (value == null) {
            return true;
        }
        int comparison = value.compareTo(this.maxValue);
        return comparison < 0 || this.inclusive && comparison == 0;
    }

    public static class ForNumber
    extends DecimalMaxValidator<Number> {
        @Override
        public boolean isValid(Number value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            BigDecimal bigValue = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : new BigDecimal(value.doubleValue()));
            return this.isValid(bigValue);
        }
    }

    public static class ForString
    extends DecimalMaxValidator<String> {
        @Override
        public boolean isValid(String value, ConstraintValidatorContext context) {
            return value == null || this.isValid(new BigDecimal(value));
        }
    }
}

