/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.io.Closeable;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.BootstrapConfiguration;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import javax.validation.valueextraction.ValueExtractor;
import org.apache.bval.jsr.ApacheValidatorConfiguration;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.BootstrapConfigurationImpl;
import org.apache.bval.jsr.DefaultConstraintValidatorFactory;
import org.apache.bval.jsr.DefaultMessageInterpolator;
import org.apache.bval.jsr.ParticipantFactory;
import org.apache.bval.jsr.parameter.DefaultParameterNameProvider;
import org.apache.bval.jsr.resolver.DefaultTraversableResolver;
import org.apache.bval.jsr.util.IOs;
import org.apache.bval.jsr.valueextraction.ValueExtractors;
import org.apache.bval.jsr.xml.ValidationParser;
import org.apache.bval.util.CloseableAble;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;

@Privilized(value="DYNAMIC")
public class ConfigurationImpl
implements ApacheValidatorConfiguration,
ConfigurationState,
CloseableAble {
    private final ValidationProvider<ApacheValidatorConfiguration> provider;
    private final ValidationProviderResolver providerResolver;
    private Class<? extends ValidationProvider<?>> providerClass;
    private final MessageInterpolator defaultMessageInterpolator = new DefaultMessageInterpolator();
    private final LazyParticipant<MessageInterpolator> messageInterpolator = new LazyParticipant(this::getDefaultMessageInterpolator);
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory = new DefaultConstraintValidatorFactory();
    private final LazyParticipant<ConstraintValidatorFactory> constraintValidatorFactory = new LazyParticipant(this::getDefaultConstraintValidatorFactory);
    private final TraversableResolver defaultTraversableResolver = new DefaultTraversableResolver();
    private final LazyParticipant<TraversableResolver> traversableResolver = new LazyParticipant(this::getDefaultTraversableResolver);
    private final ParameterNameProvider defaultParameterNameProvider = new DefaultParameterNameProvider();
    private final LazyParticipant<ParameterNameProvider> parameterNameProvider = new LazyParticipant(this::getDefaultParameterNameProvider);
    private final ClockProvider defaultClockProvider = Clock::systemDefaultZone;
    private final LazyParticipant<ClockProvider> clockProvider = new LazyParticipant(this::getDefaultClockProvider);
    private final ValueExtractors bootstrapValueExtractors = ValueExtractors.EMPTY.createChild();
    private final ValueExtractors valueExtractors = this.bootstrapValueExtractors.createChild();
    private final Lazy<BootstrapConfiguration> bootstrapConfiguration = new Lazy<BootstrapConfiguration>(this::createBootstrapConfiguration);
    private final Set<InputStream> mappingStreams = new HashSet<InputStream>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private boolean beforeCdi = false;
    private ClassLoader loader;
    private boolean prepared = false;
    private boolean ignoreXmlConfiguration = false;
    private ParticipantFactory participantFactory;
    private ValidationParser validationParser;

    public ConfigurationImpl(BootstrapState aState, ValidationProvider<ApacheValidatorConfiguration> aProvider) {
        Exceptions.raiseIf(aProvider == null && aState == null, ValidationException::new, "one of provider or state is required", new Object[0]);
        if (aProvider == null) {
            this.provider = null;
            this.providerResolver = aState.getValidationProviderResolver() == null ? aState.getDefaultValidationProviderResolver() : aState.getValidationProviderResolver();
        } else {
            this.provider = aProvider;
            this.providerResolver = null;
        }
        this.initializePropertyDefaults();
    }

    @Override
    public ApacheValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    @Override
    public ConfigurationImpl messageInterpolator(MessageInterpolator resolver) {
        return this.messageInterpolator.externalOverride(resolver);
    }

    @Override
    public ApacheValidatorConfiguration traversableResolver(TraversableResolver resolver) {
        return this.traversableResolver.externalOverride(resolver);
    }

    @Override
    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        return this.constraintValidatorFactory.externalOverride(constraintValidatorFactory);
    }

    @Override
    public ApacheValidatorConfiguration parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        return this.parameterNameProvider.externalOverride(parameterNameProvider);
    }

    @Override
    public ApacheValidatorConfiguration clockProvider(ClockProvider clockProvider) {
        return this.clockProvider.externalOverride(clockProvider);
    }

    @Override
    public ApacheValidatorConfiguration addMapping(InputStream stream) {
        if (stream != null) {
            this.mappingStreams.add(IOs.convertToMarkableInputStream(stream));
        }
        return this;
    }

    @Override
    public ApacheValidatorConfiguration addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    @Override
    public TraversableResolver getDefaultTraversableResolver() {
        return this.defaultTraversableResolver;
    }

    @Override
    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    @Override
    public ParameterNameProvider getDefaultParameterNameProvider() {
        return this.defaultParameterNameProvider;
    }

    @Override
    public ClockProvider getDefaultClockProvider() {
        return this.defaultClockProvider;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    @Override
    public Set<InputStream> getMappingStreams() {
        return this.mappingStreams;
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return (MessageInterpolator)this.messageInterpolator.get();
    }

    @Override
    public BootstrapConfiguration getBootstrapConfiguration() {
        return this.bootstrapConfiguration.get();
    }

    @Override
    public ValidatorFactory buildValidatorFactory() {
        return this.doBuildValidatorFactory();
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return (ConstraintValidatorFactory)this.constraintValidatorFactory.get();
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return (TraversableResolver)this.traversableResolver.get();
    }

    @Override
    public ParameterNameProvider getParameterNameProvider() {
        return (ParameterNameProvider)this.parameterNameProvider.get();
    }

    @Override
    public ClockProvider getClockProvider() {
        return (ClockProvider)this.clockProvider.get();
    }

    @Override
    public ApacheValidatorConfiguration addValueExtractor(ValueExtractor<?> extractor) {
        this.valueExtractors.add(extractor);
        return this;
    }

    @Override
    public Set<ValueExtractor<?>> getValueExtractors() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.valueExtractors.getValueExtractors().values()));
    }

    public void deferBootstrapOverrides() {
        this.beforeCdi = true;
    }

    public void releaseDeferredBootstrapOverrides() {
        if (this.beforeCdi) {
            this.beforeCdi = false;
            this.performBootstrapOverrides();
        }
    }

    @Override
    public Closeable getCloseable() {
        if (this.participantFactory == null) {
            return () -> {};
        }
        return this.participantFactory;
    }

    @Privileged
    private ValidatorFactory doBuildValidatorFactory() {
        if (!(System.getSecurityManager() != null)) {
            return this.__privileged_doBuildValidatorFactory();
        }
        return (ValidatorFactory)AccessController.doPrivileged(new ConfigurationImpl$doBuildValidatorFactory_ACTION(this));
    }

    static /* synthetic */ ValidatorFactory __privileged_access$0(ConfigurationImpl configurationImpl) {
        return configurationImpl.__privileged_doBuildValidatorFactory();
    }

    private ValidatorFactory __privileged_doBuildValidatorFactory() {
        this.prepare();
        return Optional.ofNullable(this.provider).orElseGet(this::findProvider).buildValidatorFactory(this);
    }

    private void prepare() {
        if (!this.prepared) {
            this.applyBootstrapConfiguration();
            this.prepared = true;
        }
    }

    private BootstrapConfiguration createBootstrapConfiguration() {
        block3: {
            BootstrapConfiguration bootstrapConfiguration;
            try {
                if (this.ignoreXmlConfiguration) break block3;
                this.loader = Reflection.loaderFromThreadOrClass(ValidationParser.class);
                this.validationParser = new ValidationParser(this.loader);
                BootstrapConfiguration xmlBootstrap = this.validationParser.processValidationConfig(this.getProperties().get("apache.bval.validation-xml-path"), this);
                if (xmlBootstrap == null) break block3;
                bootstrapConfiguration = xmlBootstrap;
            }
            catch (Throwable throwable) {
                this.participantFactory = new ParticipantFactory(this.loader);
                throw throwable;
            }
            this.participantFactory = new ParticipantFactory(this.loader);
            return bootstrapConfiguration;
        }
        this.loader = Reflection.loaderFromThreadOrClass(ApacheValidatorFactory.class);
        this.validationParser = new ValidationParser(this.loader);
        BootstrapConfigurationImpl bootstrapConfigurationImpl = BootstrapConfigurationImpl.DEFAULT;
        this.participantFactory = new ParticipantFactory(this.loader);
        return bootstrapConfigurationImpl;
    }

    private void applyBootstrapConfiguration() {
        BootstrapConfiguration bootstrapConfig = this.bootstrapConfiguration.get();
        if (bootstrapConfig.getDefaultProviderClassName() != null) {
            this.providerClass = this.loadClass(bootstrapConfig.getDefaultProviderClassName());
        }
        bootstrapConfig.getProperties().forEach(this::addProperty);
        bootstrapConfig.getConstraintMappingResourcePaths().stream().map(this.validationParser::open).forEach(this::addMapping);
        if (!this.beforeCdi) {
            this.performBootstrapOverrides();
        }
    }

    private void performBootstrapOverrides() {
        BootstrapConfiguration bootstrapConfig = this.bootstrapConfiguration.get();
        this.override(this.messageInterpolator, bootstrapConfig::getMessageInterpolatorClassName);
        this.override(this.traversableResolver, bootstrapConfig::getTraversableResolverClassName);
        this.override(this.constraintValidatorFactory, bootstrapConfig::getConstraintValidatorFactoryClassName);
        this.override(this.parameterNameProvider, bootstrapConfig::getParameterNameProviderClassName);
        this.override(this.clockProvider, bootstrapConfig::getClockProviderClassName);
        bootstrapConfig.getValueExtractorClassNames().stream().map(this.participantFactory::create).forEach(this.bootstrapValueExtractors::add);
    }

    private <T> Class<T> loadClass(String className) {
        try {
            return Class.forName(className, true, this.loader);
        }
        catch (ClassNotFoundException ex) {
            throw new ValidationException(ex);
        }
    }

    private void initializePropertyDefaults() {
        this.properties.put("apache.bval.constraints-cache-size", Integer.toString(50));
    }

    private ValidationProvider<?> findProvider() {
        if (this.providerClass == null) {
            return this.providerResolver.getValidationProviders().get(0);
        }
        Optional<ValidationProvider> knownProvider = this.providerResolver.getValidationProviders().stream().filter(this.providerClass::isInstance).findFirst();
        if (knownProvider.isPresent()) {
            return knownProvider.get();
        }
        try {
            return this.providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.create(ValidationException::new, "Unable to find/create %s of type %s", ValidationProvider.class.getSimpleName(), this.providerClass);
        }
    }

    private <T> void override(LazyParticipant<T> participant, Supplier<String> getClassName) {
        Optional.ofNullable(getClassName.get()).map(this.participantFactory::create).ifPresent(participant::override);
    }

    private class LazyParticipant<T>
    extends Lazy<T> {
        private boolean locked;

        private LazyParticipant(Supplier<T> init) {
            super(init);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConfigurationImpl override(T value) {
            if (value != null) {
                LazyParticipant lazyParticipant = this;
                synchronized (lazyParticipant) {
                    if (!this.locked) {
                        try {
                            this.reset(() -> value);
                        }
                        finally {
                            ConfigurationImpl.this.prepared = false;
                        }
                    }
                }
            }
            return ConfigurationImpl.this;
        }

        synchronized ConfigurationImpl externalOverride(T value) {
            this.locked = false;
            try {
                ConfigurationImpl configurationImpl = this.override(value);
                return configurationImpl;
            }
            finally {
                this.locked = true;
            }
        }
    }

    /*
     * Signature claims super is java.security.PrivilegedAction<javax.validation.ValidatorFactory>, not java.lang.Object - discarding signature.
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ConfigurationImpl$doBuildValidatorFactory_ACTION
    implements PrivilegedAction {
        private final ConfigurationImpl f1;

        ConfigurationImpl$doBuildValidatorFactory_ACTION(ConfigurationImpl arg1) {
            this.f1 = arg1;
        }

        public Object run() {
            return ConfigurationImpl.__privileged_access$0(this.f1);
        }
    }
}

