/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.Scope;
import org.apache.bval.jsr.descriptor.ComposedD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.Groups;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;

class Finder
implements ElementDescriptor.ConstraintFinder {
    private volatile Predicate<ConstraintD<?>> groups = c -> true;
    private volatile Predicate<ConstraintD<?>> scope;
    private volatile Predicate<ConstraintD<?>> elements;
    private final GroupsComputer groupsComputer;
    private final ElementDescriptor owner;
    private final Lazy<Groups> getDefaultSequence = new Lazy<Groups>(this::computeDefaultSequence);
    private final Lazy<Class<?>> beanClass;

    private static Stream<Group> allGroups(Groups groups) {
        return Stream.concat(groups.getGroups().stream(), groups.getSequences().stream().map(Group.Sequence::getGroups).flatMap(Collection::stream));
    }

    Finder(GroupsComputer groupsComputer, ElementDescriptor owner) {
        this.groupsComputer = Validate.notNull(groupsComputer, "groupsComputer", new Object[0]);
        this.owner = Validate.notNull(owner, "owner", new Object[0]);
        this.beanClass = new Lazy<Class>(() -> this.firstAtomicElementDescriptor().getBean().getElementClass());
    }

    @Override
    public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
        Set<Class<?>> allGroups = this.computeAll(groups);
        this.groups = c -> !Collections.disjoint(allGroups, c.getGroups());
        return this;
    }

    @Override
    public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
        this.scope = scope == Scope.HIERARCHY ? null : c -> c.getScope() == scope;
        return this;
    }

    @Override
    public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
        this.elements = c -> Stream.of(types).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(ElementType.class))).contains((Object)c.getDeclaredOn());
        return this;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.getConstraints().filter(this.filter()).collect(ToUnmodifiable.set());
    }

    @Override
    public boolean hasConstraints() {
        return this.getConstraints().anyMatch(this.filter());
    }

    private Stream<ConstraintD<?>> getConstraints() {
        return this.owner.getConstraintDescriptors().stream().map(c -> c.unwrap(ConstraintD.class));
    }

    private Predicate<ConstraintD<?>> filter() {
        Predicate<ConstraintD<?>> result = this.groups;
        if (this.scope != null) {
            result = result.and(this.scope);
        }
        if (this.elements != null) {
            result = result.and(this.elements);
        }
        return result;
    }

    private ElementD<?, ?> firstAtomicElementDescriptor() {
        return ComposedD.unwrap(this.owner, ElementD.class).findFirst().orElseThrow(IllegalStateException::new);
    }

    private Groups computeDefaultSequence() {
        ElementD<?, ?> element = this.firstAtomicElementDescriptor();
        Collection redef = element.getGroupStrategy().getGroups().stream().map(Group::getGroup).collect(Collectors.toList());
        if (redef == null) {
            return GroupsComputer.DEFAULT_GROUPS;
        }
        Class<?> t = this.beanClass.get();
        if (redef.contains(Default.class)) {
            Exceptions.raise(GroupDefinitionException::new, "%s for %s cannot include %s.class", GroupSequence.class.getSimpleName(), t, Default.class.getSimpleName());
        }
        redef = redef.stream().map(this.substituteDefaultGroup()).collect(Collectors.toCollection(LinkedHashSet::new));
        return this.groupsComputer.computeGroups(redef);
    }

    private Set<Class<?>> computeAll(Class<?>[] groups) {
        Groups preliminaryGroups = this.groupsComputer.computeGroups(Stream.of(groups).map(this.substituteDefaultGroup()));
        return Finder.allGroups(preliminaryGroups).flatMap(g2 -> g2.isDefault() ? Finder.allGroups(this.getDefaultSequence.get()) : Stream.of(g2)).map(Group::getGroup).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private UnaryOperator<Class<?>> substituteDefaultGroup() {
        return t -> t.isAssignableFrom(this.beanClass.get()) ? Default.class : t;
    }
}

