/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.validation.metadata.ExecutableDescriptor;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.ConstraintViolationImpl;
import org.apache.bval.jsr.GraphContext;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.ReturnValueD;
import org.apache.bval.jsr.job.ConstraintValidatorContextImpl;
import org.apache.bval.jsr.job.ValidateExecutable;
import org.apache.bval.jsr.job.ValidationJob;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class ValidateReturnValue<E extends Executable, T>
extends ValidateExecutable<E, T> {
    private final Object returnValue;

    ValidateReturnValue(ApacheFactoryContext validatorContext, Meta<E> meta, Object returnValue, Class<?>[] groups) {
        super(validatorContext, groups, meta);
        Type type = Validate.notNull(meta, IllegalArgumentException::new, "meta", new Object[0]).getType();
        if (!TypeUtils.isInstance(returnValue, type)) {
            Exceptions.raise(IllegalArgumentException::new, "%s is not an instance of %s", returnValue, type);
        }
        this.returnValue = returnValue;
    }

    @Override
    protected ValidationJob.Frame<?> computeBaseFrame() {
        return this.createBaseFrame((ReturnValueD)this.describe().getReturnValueDescriptor(), new GraphContext(this.validatorContext, this.createBasePath().addNode(new NodeImpl.ReturnValueNodeImpl()), this.returnValue));
    }

    @Override
    ConstraintViolationImpl<T> createViolation(String messageTemplate, String message, ConstraintValidatorContextImpl<T> context, PathImpl propertyPath) {
        return new ConstraintViolationImpl<T>(messageTemplate, message, this.getRootBean(), context.getFrame().getBean(), propertyPath, context.getFrame().context.getValue(), context.getConstraintDescriptor(), this.getRootBeanClass(), context.getConstraintDescriptor().unwrap(ConstraintD.class).getDeclaredOn(), this.returnValue, null);
    }

    @Override
    protected boolean hasWork() {
        return this.describe() != null;
    }

    protected abstract ExecutableDescriptor describe();

    protected abstract T getRootBean();

    protected abstract ValidationJob.Frame<?> createBaseFrame(ReturnValueD<?, ?> var1, GraphContext var2);

    public static class ForConstructor<T>
    extends ValidateReturnValue<Constructor<?>, T> {
        ForConstructor(ApacheFactoryContext validatorContext, Constructor<? extends T> ctor, Object returnValue, Class<?>[] groups) {
            super(validatorContext, new Meta.ForConstructor<T>(Validate.notNull(ctor, IllegalArgumentException::new, "ctor", new Object[0])), Validate.notNull(returnValue, IllegalArgumentException::new, "constructor cannot return null", new Object[0]), groups);
        }

        @Override
        protected T getRootBean() {
            return null;
        }

        @Override
        protected Class<T> getRootBeanClass() {
            return ((Constructor)this.executable).getDeclaringClass();
        }

        @Override
        protected ExecutableDescriptor describe() {
            return this.validatorContext.getDescriptorManager().getBeanDescriptor(((Constructor)this.executable).getDeclaringClass()).getConstraintsForConstructor(((Constructor)this.executable).getParameterTypes());
        }

        @Override
        protected ValidationJob.Frame<?> createBaseFrame(ReturnValueD<?, ?> descriptor, GraphContext context) {
            final Object returnValue = context.getValue();
            return new ValidationJob.SproutFrame<ReturnValueD<?, ?>>(descriptor, context){

                @Override
                Object getBean() {
                    return returnValue;
                }
            };
        }
    }

    public static class ForMethod<T>
    extends ValidateReturnValue<Method, T> {
        private final T object;

        ForMethod(ApacheFactoryContext validatorContext, T object, Method method, Object returnValue, Class<?>[] groups) {
            super(validatorContext, new Meta.ForMethod(Validate.notNull(method, IllegalArgumentException::new, "method", new Object[0])), returnValue, groups);
            this.object = Validate.notNull(object, IllegalArgumentException::new, "object", new Object[0]);
        }

        @Override
        protected T getRootBean() {
            return this.object;
        }

        @Override
        protected Class<T> getRootBeanClass() {
            return this.object.getClass();
        }

        @Override
        protected ExecutableDescriptor describe() {
            return this.validatorContext.getDescriptorManager().getBeanDescriptor(this.object.getClass()).getConstraintsForMethod(((Method)this.executable).getName(), ((Method)this.executable).getParameterTypes());
        }

        @Override
        protected ValidationJob.Frame<?> createBaseFrame(ReturnValueD<?, ?> descriptor, GraphContext context) {
            return new ValidationJob.SproutFrame<ReturnValueD<?, ?>>(descriptor, context){

                @Override
                Object getBean() {
                    return this.getRootBean();
                }
            };
        }
    }
}

